/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisTargetStatusReason {
    SCAN_IN_PROGRESS("SCAN_IN_PROGRESS"),
    UNSUPPORTED_OS("UNSUPPORTED_OS"),
    SSM_UNMANAGED("SSM_UNMANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisTargetStatusReason> VALUE_MAP;
    private final String value;

    private CisTargetStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisTargetStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisTargetStatusReason> knownValues() {
        EnumSet<CisTargetStatusReason> knownValues = EnumSet.allOf(CisTargetStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisTargetStatusReason.class, CisTargetStatusReason::toString);
    }
}

