/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CodeSnippetErrorCode {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    ACCESS_DENIED("ACCESS_DENIED"),
    CODE_SNIPPET_NOT_FOUND("CODE_SNIPPET_NOT_FOUND"),
    INVALID_INPUT("INVALID_INPUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CodeSnippetErrorCode> VALUE_MAP;
    private final String value;

    private CodeSnippetErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CodeSnippetErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CodeSnippetErrorCode> knownValues() {
        EnumSet<CodeSnippetErrorCode> knownValues = EnumSet.allOf(CodeSnippetErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CodeSnippetErrorCode.class, CodeSnippetErrorCode::toString);
    }
}

