/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CoveredResource;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;

public class ListCoverageIterable
implements SdkIterable<ListCoverageResponse> {
    private final Inspector2Client client;
    private final ListCoverageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoverageIterable(Inspector2Client client, ListCoverageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoverageResponseFetcher();
    }

    public Iterator<ListCoverageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoveredResource> coveredResources() {
        Function<ListCoverageResponse, Iterator> getIterator = response -> {
            if (response != null && response.coveredResources() != null) {
                return response.coveredResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoverageResponseFetcher
    implements SyncPageFetcher<ListCoverageResponse> {
        private ListCoverageResponseFetcher() {
        }

        public boolean hasNextPage(ListCoverageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoverageResponse nextPage(ListCoverageResponse previousPage) {
            if (previousPage == null) {
                return ListCoverageIterable.this.client.listCoverage(ListCoverageIterable.this.firstRequest);
            }
            return ListCoverageIterable.this.client.listCoverage((ListCoverageRequest)((Object)ListCoverageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

