/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Destination;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.ResourceFilterCriteria;
import software.amazon.awssdk.services.inspector2.model.SbomReportFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSbomExportRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, CreateSbomExportRequest> {
    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFormat").getter(CreateSbomExportRequest.getter(CreateSbomExportRequest::reportFormatAsString)).setter(CreateSbomExportRequest.setter(Builder::reportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFormat").build()}).build();
    private static final SdkField<ResourceFilterCriteria> RESOURCE_FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceFilterCriteria").getter(CreateSbomExportRequest.getter(CreateSbomExportRequest::resourceFilterCriteria)).setter(CreateSbomExportRequest.setter(Builder::resourceFilterCriteria)).constructor(ResourceFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceFilterCriteria").build()}).build();
    private static final SdkField<Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(CreateSbomExportRequest.getter(CreateSbomExportRequest::s3Destination)).setter(CreateSbomExportRequest.setter(Builder::s3Destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_FORMAT_FIELD, RESOURCE_FILTER_CRITERIA_FIELD, S3_DESTINATION_FIELD));
    private final String reportFormat;
    private final ResourceFilterCriteria resourceFilterCriteria;
    private final Destination s3Destination;

    private CreateSbomExportRequest(BuilderImpl builder) {
        super(builder);
        this.reportFormat = builder.reportFormat;
        this.resourceFilterCriteria = builder.resourceFilterCriteria;
        this.s3Destination = builder.s3Destination;
    }

    public final SbomReportFormat reportFormat() {
        return SbomReportFormat.fromValue(this.reportFormat);
    }

    public final String reportFormatAsString() {
        return this.reportFormat;
    }

    public final ResourceFilterCriteria resourceFilterCriteria() {
        return this.resourceFilterCriteria;
    }

    public final Destination s3Destination() {
        return this.s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceFilterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSbomExportRequest)) {
            return false;
        }
        CreateSbomExportRequest other = (CreateSbomExportRequest)((Object)obj);
        return Objects.equals(this.reportFormatAsString(), other.reportFormatAsString()) && Objects.equals(this.resourceFilterCriteria(), other.resourceFilterCriteria()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSbomExportRequest").add("ReportFormat", (Object)this.reportFormatAsString()).add("ResourceFilterCriteria", (Object)this.resourceFilterCriteria()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportFormat": {
                return Optional.ofNullable(clazz.cast(this.reportFormatAsString()));
            }
            case "resourceFilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.resourceFilterCriteria()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSbomExportRequest, T> g) {
        return obj -> g.apply((CreateSbomExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String reportFormat;
        private ResourceFilterCriteria resourceFilterCriteria;
        private Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSbomExportRequest model) {
            super(model);
            this.reportFormat(model.reportFormat);
            this.resourceFilterCriteria(model.resourceFilterCriteria);
            this.s3Destination(model.s3Destination);
        }

        public final String getReportFormat() {
            return this.reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        public final Builder reportFormat(SbomReportFormat reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final ResourceFilterCriteria.Builder getResourceFilterCriteria() {
            return this.resourceFilterCriteria != null ? this.resourceFilterCriteria.toBuilder() : null;
        }

        public final void setResourceFilterCriteria(ResourceFilterCriteria.BuilderImpl resourceFilterCriteria) {
            this.resourceFilterCriteria = resourceFilterCriteria != null ? resourceFilterCriteria.build() : null;
        }

        @Override
        public final Builder resourceFilterCriteria(ResourceFilterCriteria resourceFilterCriteria) {
            this.resourceFilterCriteria = resourceFilterCriteria;
            return this;
        }

        public final Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSbomExportRequest build() {
            return new CreateSbomExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSbomExportRequest> {
        public Builder reportFormat(String var1);

        public Builder reportFormat(SbomReportFormat var1);

        public Builder resourceFilterCriteria(ResourceFilterCriteria var1);

        default public Builder resourceFilterCriteria(Consumer<ResourceFilterCriteria.Builder> resourceFilterCriteria) {
            return this.resourceFilterCriteria((ResourceFilterCriteria)((ResourceFilterCriteria.Builder)ResourceFilterCriteria.builder().applyMutation(resourceFilterCriteria)).build());
        }

        public Builder s3Destination(Destination var1);

        default public Builder s3Destination(Consumer<Destination.Builder> s3Destination) {
            return this.s3Destination((Destination)((Destination.Builder)Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

