/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector2.model.LambdaLayerListCopier;
import software.amazon.awssdk.services.inspector2.model.Runtime;
import software.amazon.awssdk.services.inspector2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionMetadata> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("functionName").getter(LambdaFunctionMetadata.getter(LambdaFunctionMetadata::functionName)).setter(LambdaFunctionMetadata.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()}).build();
    private static final SdkField<Map<String, String>> FUNCTION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("functionTags").getter(LambdaFunctionMetadata.getter(LambdaFunctionMetadata::functionTags)).setter(LambdaFunctionMetadata.setter(Builder::functionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layers").getter(LambdaFunctionMetadata.getter(LambdaFunctionMetadata::layers)).setter(LambdaFunctionMetadata.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(LambdaFunctionMetadata.getter(LambdaFunctionMetadata::runtimeAsString)).setter(LambdaFunctionMetadata.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, FUNCTION_TAGS_FIELD, LAYERS_FIELD, RUNTIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String functionName;
    private final Map<String, String> functionTags;
    private final List<String> layers;
    private final String runtime;

    private LambdaFunctionMetadata(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.functionTags = builder.functionTags;
        this.layers = builder.layers;
        this.runtime = builder.runtime;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final boolean hasFunctionTags() {
        return this.functionTags != null && !(this.functionTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> functionTags() {
        return this.functionTags;
    }

    public final boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public final List<String> layers() {
        return this.layers;
    }

    public final Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionTags() ? this.functionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayers() ? this.layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMetadata)) {
            return false;
        }
        LambdaFunctionMetadata other = (LambdaFunctionMetadata)obj;
        return Objects.equals(this.functionName(), other.functionName()) && this.hasFunctionTags() == other.hasFunctionTags() && Objects.equals(this.functionTags(), other.functionTags()) && this.hasLayers() == other.hasLayers() && Objects.equals(this.layers(), other.layers()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionMetadata").add("FunctionName", (Object)this.functionName()).add("FunctionTags", this.hasFunctionTags() ? this.functionTags() : null).add("Layers", this.hasLayers() ? this.layers() : null).add("Runtime", (Object)this.runtimeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "functionTags": {
                return Optional.ofNullable(clazz.cast(this.functionTags()));
            }
            case "layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionMetadata, T> g) {
        return obj -> g.apply((LambdaFunctionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private Map<String, String> functionTags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> layers = DefaultSdkAutoConstructList.getInstance();
        private String runtime;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionMetadata model) {
            this.functionName(model.functionName);
            this.functionTags(model.functionTags);
            this.layers(model.layers);
            this.runtime(model.runtime);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Map<String, String> getFunctionTags() {
            if (this.functionTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.functionTags;
        }

        public final void setFunctionTags(Map<String, String> functionTags) {
            this.functionTags = TagMapCopier.copy(functionTags);
        }

        @Override
        public final Builder functionTags(Map<String, String> functionTags) {
            this.functionTags = TagMapCopier.copy(functionTags);
            return this;
        }

        public final Collection<String> getLayers() {
            if (this.layers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LambdaLayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LambdaLayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public LambdaFunctionMetadata build() {
            return new LambdaFunctionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionMetadata> {
        public Builder functionName(String var1);

        public Builder functionTags(Map<String, String> var1);

        public Builder layers(Collection<String> var1);

        public Builder layers(String ... var1);

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);
    }
}

