/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on operating system package type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageAggregation.Builder, PackageAggregation> {
    private static final SdkField<List<StringFilter>> PACKAGE_NAMES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("packageNames")
            .getter(getter(PackageAggregation::packageNames))
            .setter(setter(Builder::packageNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(PackageAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(PackageAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAMES_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> packageNames;

    private final String sortBy;

    private final String sortOrder;

    private PackageAggregation(BuilderImpl builder) {
        this.packageNames = builder.packageNames;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageNames() {
        return packageNames != null && !(packageNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of packages to aggregate findings on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageNames} method.
     * </p>
     * 
     * @return The names of packages to aggregate findings on.
     */
    public final List<StringFilter> packageNames() {
        return packageNames;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link PackageSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see PackageSortBy
     */
    public final PackageSortBy sortBy() {
        return PackageSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link PackageSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see PackageSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageNames() ? packageNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageAggregation)) {
            return false;
        }
        PackageAggregation other = (PackageAggregation) obj;
        return hasPackageNames() == other.hasPackageNames() && Objects.equals(packageNames(), other.packageNames())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageAggregation").add("PackageNames", hasPackageNames() ? packageNames() : null)
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageNames":
            return Optional.ofNullable(clazz.cast(packageNames()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageAggregation, T> g) {
        return obj -> g.apply((PackageAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageAggregation> {
        /**
         * <p>
         * The names of packages to aggregate findings on.
         * </p>
         * 
         * @param packageNames
         *        The names of packages to aggregate findings on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageNames(Collection<StringFilter> packageNames);

        /**
         * <p>
         * The names of packages to aggregate findings on.
         * </p>
         * 
         * @param packageNames
         *        The names of packages to aggregate findings on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageNames(StringFilter... packageNames);

        /**
         * <p>
         * The names of packages to aggregate findings on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #packageNames(List<StringFilter>)}.
         * 
         * @param packageNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageNames(java.util.Collection<StringFilter>)
         */
        Builder packageNames(Consumer<StringFilter.Builder>... packageNames);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see PackageSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see PackageSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageSortBy
         */
        Builder sortBy(PackageSortBy sortBy);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> packageNames = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageAggregation model) {
            packageNames(model.packageNames);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getPackageNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.packageNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageNames(Collection<StringFilter.BuilderImpl> packageNames) {
            this.packageNames = StringFilterListCopier.copyFromBuilder(packageNames);
        }

        @Override
        public final Builder packageNames(Collection<StringFilter> packageNames) {
            this.packageNames = StringFilterListCopier.copy(packageNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageNames(StringFilter... packageNames) {
            packageNames(Arrays.asList(packageNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageNames(Consumer<StringFilter.Builder>... packageNames) {
            packageNames(Stream.of(packageNames).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(PackageSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public PackageAggregation build() {
            return new PackageAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
