/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanStatus implements SdkPojo, Serializable, ToCopyableBuilder<ScanStatus.Builder, ScanStatus> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ScanStatus::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(ScanStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String statusCodeValue;

    private ScanStatus(BuilderImpl builder) {
        this.reason = builder.reason;
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * The reason for the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ScanStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the scan.
     * @see ScanStatusReason
     */
    public final ScanStatusReason reason() {
        return ScanStatusReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ScanStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the scan.
     * @see ScanStatusReason
     */
    public final String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The status code of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the scan.
     * @see ScanStatusCode
     */
    public final ScanStatusCode statusCode() {
        return ScanStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScanStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the scan.
     * @see ScanStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanStatus)) {
            return false;
        }
        ScanStatus other = (ScanStatus) obj;
        return Objects.equals(reasonAsString(), other.reasonAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanStatus").add("Reason", reasonAsString()).add("StatusCode", statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanStatus, T> g) {
        return obj -> g.apply((ScanStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanStatus> {
        /**
         * <p>
         * The reason for the scan.
         * </p>
         * 
         * @param reason
         *        The reason for the scan.
         * @see ScanStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for the scan.
         * </p>
         * 
         * @param reason
         *        The reason for the scan.
         * @see ScanStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusReason
         */
        Builder reason(ScanStatusReason reason);

        /**
         * <p>
         * The status code of the scan.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code of the scan.
         * @see ScanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code of the scan.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code of the scan.
         * @see ScanStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanStatusCode
         */
        Builder statusCode(ScanStatusCode statusCodeValue);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanStatus model) {
            reason(model.reason);
            statusCode(model.statusCodeValue);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ScanStatusReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(ScanStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        @Override
        public ScanStatus build() {
            return new ScanStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
