/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding aggregation by image layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageLayerAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageLayerAggregationResponse.Builder, ImageLayerAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(ImageLayerAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> LAYER_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerHash").getter(getter(ImageLayerAggregationResponse::layerHash)).setter(setter(Builder::layerHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerHash").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(ImageLayerAggregationResponse::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ImageLayerAggregationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(ImageLayerAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            LAYER_HASH_FIELD, REPOSITORY_FIELD, RESOURCE_ID_FIELD, SEVERITY_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String layerHash;

    private final String repository;

    private final String resourceId;

    private final SeverityCounts severityCounts;

    private ImageLayerAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.layerHash = builder.layerHash;
        this.repository = builder.repository;
        this.resourceId = builder.resourceId;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the container image hosting the layer image.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the container image hosting the layer image.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The layer hash.
     * </p>
     * 
     * @return The layer hash.
     */
    public final String layerHash() {
        return layerHash;
    }

    /**
     * <p>
     * The repository the layer resides in.
     * </p>
     * 
     * @return The repository the layer resides in.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The resource ID of the container image layer.
     * </p>
     * 
     * @return The resource ID of the container image layer.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * An object that represents the count of matched findings per severity.
     * </p>
     * 
     * @return An object that represents the count of matched findings per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(layerHash());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageLayerAggregationResponse)) {
            return false;
        }
        ImageLayerAggregationResponse other = (ImageLayerAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(layerHash(), other.layerHash())
                && Objects.equals(repository(), other.repository()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageLayerAggregationResponse").add("AccountId", accountId()).add("LayerHash", layerHash())
                .add("Repository", repository()).add("ResourceId", resourceId()).add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "layerHash":
            return Optional.ofNullable(clazz.cast(layerHash()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageLayerAggregationResponse, T> g) {
        return obj -> g.apply((ImageLayerAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageLayerAggregationResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the container image hosting the layer image.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that owns the container image hosting the layer image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The layer hash.
         * </p>
         * 
         * @param layerHash
         *        The layer hash.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerHash(String layerHash);

        /**
         * <p>
         * The repository the layer resides in.
         * </p>
         * 
         * @param repository
         *        The repository the layer resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The resource ID of the container image layer.
         * </p>
         * 
         * @param resourceId
         *        The resource ID of the container image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * An object that represents the count of matched findings per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that represents the count of matched findings per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that represents the count of matched findings per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String layerHash;

        private String repository;

        private String resourceId;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageLayerAggregationResponse model) {
            accountId(model.accountId);
            layerHash(model.layerHash);
            repository(model.repository);
            resourceId(model.resourceId);
            severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getLayerHash() {
            return layerHash;
        }

        public final void setLayerHash(String layerHash) {
            this.layerHash = layerHash;
        }

        @Override
        public final Builder layerHash(String layerHash) {
            this.layerHash = layerHash;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public ImageLayerAggregationResponse build() {
            return new ImageLayerAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
