/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEc2DeepInspectionConfigurationResponse extends Inspector2Response implements
        ToCopyableBuilder<GetEc2DeepInspectionConfigurationResponse.Builder, GetEc2DeepInspectionConfigurationResponse> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetEc2DeepInspectionConfigurationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<String>> ORG_PACKAGE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("orgPackagePaths")
            .getter(getter(GetEc2DeepInspectionConfigurationResponse::orgPackagePaths))
            .setter(setter(Builder::orgPackagePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orgPackagePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PACKAGE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("packagePaths")
            .getter(getter(GetEc2DeepInspectionConfigurationResponse::packagePaths))
            .setter(setter(Builder::packagePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEc2DeepInspectionConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            ORG_PACKAGE_PATHS_FIELD, PACKAGE_PATHS_FIELD, STATUS_FIELD));

    private final String errorMessage;

    private final List<String> orgPackagePaths;

    private final List<String> packagePaths;

    private final String status;

    private GetEc2DeepInspectionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.errorMessage = builder.errorMessage;
        this.orgPackagePaths = builder.orgPackagePaths;
        this.packagePaths = builder.packagePaths;
        this.status = builder.status;
    }

    /**
     * <p>
     * An error message explaining why Amazon Inspector deep inspection configurations could not be retrieved for your
     * account.
     * </p>
     * 
     * @return An error message explaining why Amazon Inspector deep inspection configurations could not be retrieved
     *         for your account.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrgPackagePaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrgPackagePaths() {
        return orgPackagePaths != null && !(orgPackagePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Inspector deep inspection custom paths for your organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrgPackagePaths} method.
     * </p>
     * 
     * @return The Amazon Inspector deep inspection custom paths for your organization.
     */
    public final List<String> orgPackagePaths() {
        return orgPackagePaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackagePaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackagePaths() {
        return packagePaths != null && !(packagePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Inspector deep inspection custom paths for your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackagePaths} method.
     * </p>
     * 
     * @return The Amazon Inspector deep inspection custom paths for your account.
     */
    public final List<String> packagePaths() {
        return packagePaths;
    }

    /**
     * <p>
     * The activation status of Amazon Inspector deep inspection in your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Ec2DeepInspectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The activation status of Amazon Inspector deep inspection in your account.
     * @see Ec2DeepInspectionStatus
     */
    public final Ec2DeepInspectionStatus status() {
        return Ec2DeepInspectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The activation status of Amazon Inspector deep inspection in your account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Ec2DeepInspectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The activation status of Amazon Inspector deep inspection in your account.
     * @see Ec2DeepInspectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrgPackagePaths() ? orgPackagePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPackagePaths() ? packagePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2DeepInspectionConfigurationResponse)) {
            return false;
        }
        GetEc2DeepInspectionConfigurationResponse other = (GetEc2DeepInspectionConfigurationResponse) obj;
        return Objects.equals(errorMessage(), other.errorMessage()) && hasOrgPackagePaths() == other.hasOrgPackagePaths()
                && Objects.equals(orgPackagePaths(), other.orgPackagePaths()) && hasPackagePaths() == other.hasPackagePaths()
                && Objects.equals(packagePaths(), other.packagePaths())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEc2DeepInspectionConfigurationResponse").add("ErrorMessage", errorMessage())
                .add("OrgPackagePaths", hasOrgPackagePaths() ? orgPackagePaths() : null)
                .add("PackagePaths", hasPackagePaths() ? packagePaths() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "orgPackagePaths":
            return Optional.ofNullable(clazz.cast(orgPackagePaths()));
        case "packagePaths":
            return Optional.ofNullable(clazz.cast(packagePaths()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEc2DeepInspectionConfigurationResponse, T> g) {
        return obj -> g.apply((GetEc2DeepInspectionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEc2DeepInspectionConfigurationResponse> {
        /**
         * <p>
         * An error message explaining why Amazon Inspector deep inspection configurations could not be retrieved for
         * your account.
         * </p>
         * 
         * @param errorMessage
         *        An error message explaining why Amazon Inspector deep inspection configurations could not be retrieved
         *        for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths for your organization.
         * </p>
         * 
         * @param orgPackagePaths
         *        The Amazon Inspector deep inspection custom paths for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orgPackagePaths(Collection<String> orgPackagePaths);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths for your organization.
         * </p>
         * 
         * @param orgPackagePaths
         *        The Amazon Inspector deep inspection custom paths for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orgPackagePaths(String... orgPackagePaths);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths for your account.
         * </p>
         * 
         * @param packagePaths
         *        The Amazon Inspector deep inspection custom paths for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagePaths(Collection<String> packagePaths);

        /**
         * <p>
         * The Amazon Inspector deep inspection custom paths for your account.
         * </p>
         * 
         * @param packagePaths
         *        The Amazon Inspector deep inspection custom paths for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagePaths(String... packagePaths);

        /**
         * <p>
         * The activation status of Amazon Inspector deep inspection in your account.
         * </p>
         * 
         * @param status
         *        The activation status of Amazon Inspector deep inspection in your account.
         * @see Ec2DeepInspectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2DeepInspectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The activation status of Amazon Inspector deep inspection in your account.
         * </p>
         * 
         * @param status
         *        The activation status of Amazon Inspector deep inspection in your account.
         * @see Ec2DeepInspectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2DeepInspectionStatus
         */
        Builder status(Ec2DeepInspectionStatus status);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String errorMessage;

        private List<String> orgPackagePaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> packagePaths = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2DeepInspectionConfigurationResponse model) {
            super(model);
            errorMessage(model.errorMessage);
            orgPackagePaths(model.orgPackagePaths);
            packagePaths(model.packagePaths);
            status(model.status);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getOrgPackagePaths() {
            if (orgPackagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return orgPackagePaths;
        }

        public final void setOrgPackagePaths(Collection<String> orgPackagePaths) {
            this.orgPackagePaths = PathListCopier.copy(orgPackagePaths);
        }

        @Override
        public final Builder orgPackagePaths(Collection<String> orgPackagePaths) {
            this.orgPackagePaths = PathListCopier.copy(orgPackagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orgPackagePaths(String... orgPackagePaths) {
            orgPackagePaths(Arrays.asList(orgPackagePaths));
            return this;
        }

        public final Collection<String> getPackagePaths() {
            if (packagePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return packagePaths;
        }

        public final void setPackagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
        }

        @Override
        public final Builder packagePaths(Collection<String> packagePaths) {
            this.packagePaths = PathListCopier.copy(packagePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagePaths(String... packagePaths) {
            packagePaths(Arrays.asList(packagePaths));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Ec2DeepInspectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetEc2DeepInspectionConfigurationResponse build() {
            return new GetEc2DeepInspectionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
