/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on finding type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingTypeAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingTypeAggregation.Builder, FindingTypeAggregation> {
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingType").getter(getter(FindingTypeAggregation::findingTypeAsString))
            .setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(FindingTypeAggregation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(FindingTypeAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(FindingTypeAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPE_FIELD,
            RESOURCE_TYPE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingType;

    private final String resourceType;

    private final String sortBy;

    private final String sortOrder;

    private FindingTypeAggregation(BuilderImpl builder) {
        this.findingType = builder.findingType;
        this.resourceType = builder.resourceType;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The finding type to aggregate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link AggregationFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The finding type to aggregate.
     * @see AggregationFindingType
     */
    public final AggregationFindingType findingType() {
        return AggregationFindingType.fromValue(findingType);
    }

    /**
     * <p>
     * The finding type to aggregate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link AggregationFindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The finding type to aggregate.
     * @see AggregationFindingType
     */
    public final String findingTypeAsString() {
        return findingType;
    }

    /**
     * <p>
     * The resource type to aggregate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AggregationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to aggregate.
     * @see AggregationResourceType
     */
    public final AggregationResourceType resourceType() {
        return AggregationResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type to aggregate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link AggregationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type to aggregate.
     * @see AggregationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FindingTypeSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see FindingTypeSortBy
     */
    public final FindingTypeSortBy sortBy() {
        return FindingTypeSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FindingTypeSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see FindingTypeSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingTypeAggregation)) {
            return false;
        }
        FindingTypeAggregation other = (FindingTypeAggregation) obj;
        return Objects.equals(findingTypeAsString(), other.findingTypeAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingTypeAggregation").add("FindingType", findingTypeAsString())
                .add("ResourceType", resourceTypeAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingTypeAsString()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingTypeAggregation, T> g) {
        return obj -> g.apply((FindingTypeAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingTypeAggregation> {
        /**
         * <p>
         * The finding type to aggregate.
         * </p>
         * 
         * @param findingType
         *        The finding type to aggregate.
         * @see AggregationFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFindingType
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The finding type to aggregate.
         * </p>
         * 
         * @param findingType
         *        The finding type to aggregate.
         * @see AggregationFindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFindingType
         */
        Builder findingType(AggregationFindingType findingType);

        /**
         * <p>
         * The resource type to aggregate.
         * </p>
         * 
         * @param resourceType
         *        The resource type to aggregate.
         * @see AggregationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type to aggregate.
         * </p>
         * 
         * @param resourceType
         *        The resource type to aggregate.
         * @see AggregationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationResourceType
         */
        Builder resourceType(AggregationResourceType resourceType);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see FindingTypeSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingTypeSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see FindingTypeSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingTypeSortBy
         */
        Builder sortBy(FindingTypeSortBy sortBy);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String findingType;

        private String resourceType;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingTypeAggregation model) {
            findingType(model.findingType);
            resourceType(model.resourceType);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(AggregationFindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(AggregationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(FindingTypeSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public FindingTypeAggregation build() {
            return new FindingTypeAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
