/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.model.CoveredResource;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;

public class ListCoveragePublisher
implements SdkPublisher<ListCoverageResponse> {
    private final Inspector2AsyncClient client;
    private final ListCoverageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCoveragePublisher(Inspector2AsyncClient client, ListCoverageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCoveragePublisher(Inspector2AsyncClient client, ListCoverageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCoverageResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCoverageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoveredResource> coveredResources() {
        Function<ListCoverageResponse, Iterator> getIterator = response -> {
            if (response != null && response.coveredResources() != null) {
                return response.coveredResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCoverageResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCoverageResponseFetcher
    implements AsyncPageFetcher<ListCoverageResponse> {
        private ListCoverageResponseFetcher() {
        }

        public boolean hasNextPage(ListCoverageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCoverageResponse> nextPage(ListCoverageResponse previousPage) {
            if (previousPage == null) {
                return ListCoveragePublisher.this.client.listCoverage(ListCoveragePublisher.this.firstRequest);
            }
            return ListCoveragePublisher.this.client.listCoverage((ListCoverageRequest)((Object)ListCoveragePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

