/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExploitAvailable {
    YES("YES"),
    NO("NO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExploitAvailable> VALUE_MAP;
    private final String value;

    private ExploitAvailable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExploitAvailable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExploitAvailable> knownValues() {
        EnumSet<ExploitAvailable> knownValues = EnumSet.allOf(ExploitAvailable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExploitAvailable.class, ExploitAvailable::toString);
    }
}

