/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.Finding;
import software.amazon.awssdk.services.inspector.model.FindingListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFindingsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeFindingsResponse> {
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findings").getter(DescribeFindingsResponse.getter(DescribeFindingsResponse::findings)).setter(DescribeFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Finding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeFindingsResponse.getter(DescribeFindingsResponse::failedItems)).setter(DescribeFindingsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD, FAILED_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFindingsResponse.memberNameToFieldInitializer();
    private final List<Finding> findings;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.failedItems = builder.failedItems;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<Finding> findings() {
        return this.findings;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFindingsResponse)) {
            return false;
        }
        DescribeFindingsResponse other = (DescribeFindingsResponse)((Object)obj);
        return this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFindingsResponse").add("Findings", this.hasFindings() ? this.findings() : null).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findings", FINDINGS_FIELD);
        map.put("failedItems", FAILED_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFindingsResponse, T> g) {
        return obj -> g.apply((DescribeFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFindingsResponse model) {
            super(model);
            this.findings(model.findings);
            this.failedItems(model.failedItems);
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingListCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingListCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            Map<String, FailedItemDetails.Builder> result = FailedItemsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        @Override
        public DescribeFindingsResponse build() {
            return new DescribeFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFindingsResponse> {
        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

