/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkAsyncHttpClientBuilder;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.imds.Ec2MetadataAsyncClient;
import software.amazon.awssdk.imds.Ec2MetadataResponse;
import software.amazon.awssdk.imds.Ec2MetadataRetryPolicy;
import software.amazon.awssdk.imds.EndpointMode;
import software.amazon.awssdk.imds.internal.AsyncHttpRequestHelper;
import software.amazon.awssdk.imds.internal.AsyncTokenCache;
import software.amazon.awssdk.imds.internal.BaseEc2MetadataClient;
import software.amazon.awssdk.imds.internal.DefaultEc2MetadataClient;
import software.amazon.awssdk.imds.internal.Token;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@Immutable
@ThreadSafe
public final class DefaultEc2MetadataAsyncClient
extends BaseEc2MetadataClient
implements Ec2MetadataAsyncClient {
    private static final Logger log = Logger.loggerFor(DefaultEc2MetadataClient.class);
    private static final int DEFAULT_RETRY_THREAD_POOL_SIZE = 3;
    private final SdkAsyncHttpClient httpClient;
    private final ScheduledExecutorService asyncRetryScheduler;
    private final boolean httpClientIsInternal;
    private final boolean retryExecutorIsInternal;
    private final AsyncTokenCache tokenCache;

    private DefaultEc2MetadataAsyncClient(Ec2MetadataAsyncBuilder builder) {
        super(builder);
        Validate.isTrue((builder.httpClient == null || builder.httpClientBuilder == null ? 1 : 0) != 0, (String)"The httpClient and the httpClientBuilder can't both be configured.", (Object[])new Object[0]);
        this.httpClient = Either.fromNullable((Object)builder.httpClient, (Object)builder.httpClientBuilder).map(e -> (SdkAsyncHttpClient)e.map(Function.identity(), SdkAsyncHttpClient.Builder::build)).orElseGet(() -> new DefaultSdkAsyncHttpClientBuilder().buildWithDefaults(this.imdsHttpDefaults()));
        this.httpClientIsInternal = builder.httpClient == null;
        this.asyncRetryScheduler = (ScheduledExecutorService)Validate.getOrDefault((Object)builder.scheduledExecutorService, () -> {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().threadNamePrefix("IMDS-ScheduledExecutor").build();
            return Executors.newScheduledThreadPool(3, threadFactory);
        });
        this.retryExecutorIsInternal = builder.scheduledExecutorService == null;
        Supplier<CompletableFuture<Token>> tokenSupplier = () -> {
            SdkHttpFullRequest baseTokenRequest = this.requestMarshaller.createTokenRequest(this.tokenTtl);
            return AsyncHttpRequestHelper.sendAsyncTokenRequest(this.httpClient, baseTokenRequest);
        };
        this.tokenCache = new AsyncTokenCache(tokenSupplier);
    }

    public static Ec2MetadataAsyncClient.Builder builder() {
        return new Ec2MetadataAsyncBuilder();
    }

    @Override
    public CompletableFuture<Ec2MetadataResponse> get(String path) {
        CompletableFuture<Ec2MetadataResponse> returnFuture = new CompletableFuture<Ec2MetadataResponse>();
        this.get(path, RetryPolicyContext.builder().retriesAttempted(0).build(), returnFuture);
        return returnFuture;
    }

    private void get(String path, RetryPolicyContext retryPolicyContext, CompletableFuture<Ec2MetadataResponse> returnFuture) {
        Object tokenFuture = this.tokenCache.get();
        CompletionStage result = ((CompletableFuture)((CompletableFuture)tokenFuture).thenCompose(token -> {
            SdkHttpFullRequest baseMetadataRequest = this.requestMarshaller.createDataRequest(path, token.value(), this.tokenTtl);
            return AsyncHttpRequestHelper.sendAsyncMetadataRequest(this.httpClient, baseMetadataRequest, returnFuture);
        })).thenApply(Ec2MetadataResponse::create);
        CompletableFutureUtils.forwardExceptionTo(returnFuture, (CompletableFuture)result);
        ((CompletableFuture)result).whenComplete((response, error) -> {
            if (response != null) {
                returnFuture.complete((Ec2MetadataResponse)response);
                return;
            }
            if (!this.shouldRetry(retryPolicyContext, (Throwable)error)) {
                returnFuture.completeExceptionally((Throwable)error);
                return;
            }
            int newAttempt = retryPolicyContext.retriesAttempted() + 1;
            log.debug(() -> "Retrying request: Attempt " + newAttempt);
            RetryPolicyContext newContext = RetryPolicyContext.builder().retriesAttempted(newAttempt).exception((SdkException)SdkClientException.create((String)error.getMessage(), (Throwable)error)).build();
            this.scheduledRetryAttempt(() -> this.get(path, newContext, returnFuture), newContext);
        });
    }

    private void scheduledRetryAttempt(Runnable runnable, RetryPolicyContext retryPolicyContext) {
        Duration retryDelay = this.retryPolicy.backoffStrategy().computeDelayBeforeNextRetry(retryPolicyContext);
        Executor retryExecutor = retryAttempt -> this.asyncRetryScheduler.schedule(retryAttempt, retryDelay.toMillis(), TimeUnit.MILLISECONDS);
        CompletableFuture.runAsync(runnable, retryExecutor);
    }

    public void close() {
        if (this.httpClientIsInternal) {
            this.httpClient.close();
        }
        if (this.retryExecutorIsInternal) {
            this.asyncRetryScheduler.shutdown();
        }
    }

    protected static final class Ec2MetadataAsyncBuilder
    implements Ec2MetadataAsyncClient.Builder {
        private Ec2MetadataRetryPolicy retryPolicy;
        private URI endpoint;
        private Duration tokenTtl;
        private EndpointMode endpointMode;
        private SdkAsyncHttpClient httpClient;
        private SdkAsyncHttpClient.Builder<?> httpClientBuilder;
        private ScheduledExecutorService scheduledExecutorService;

        private Ec2MetadataAsyncBuilder() {
        }

        @Override
        public Ec2MetadataAsyncBuilder retryPolicy(Ec2MetadataRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder retryPolicy(Consumer<Ec2MetadataRetryPolicy.Builder> builderConsumer) {
            Validate.notNull(builderConsumer, (String)"builderConsumer must not be null", (Object[])new Object[0]);
            Ec2MetadataRetryPolicy.Builder builder = Ec2MetadataRetryPolicy.builder();
            builderConsumer.accept(builder);
            this.retryPolicy = (Ec2MetadataRetryPolicy)builder.build();
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder tokenTtl(Duration tokenTtl) {
            this.tokenTtl = tokenTtl;
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder endpointMode(EndpointMode endpointMode) {
            this.endpointMode = endpointMode;
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder httpClient(SdkAsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Override
        public Ec2MetadataAsyncClient.Builder httpClient(SdkAsyncHttpClient.Builder<?> builder) {
            this.httpClientBuilder = builder;
            return this;
        }

        @Override
        public Ec2MetadataAsyncBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Ec2MetadataRetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public URI getEndpoint() {
            return this.endpoint;
        }

        public Duration getTokenTtl() {
            return this.tokenTtl;
        }

        public EndpointMode getEndpointMode() {
            return this.endpointMode;
        }

        public Ec2MetadataAsyncClient build() {
            return new DefaultEc2MetadataAsyncClient(this);
        }
    }
}

