/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.internal.http.async.AsyncResponseHandler;
import software.amazon.awssdk.core.internal.http.async.SimpleHttpContentPublisher;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.imds.Ec2MetadataClientException;
import software.amazon.awssdk.imds.internal.BaseEc2MetadataClient;
import software.amazon.awssdk.imds.internal.Token;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class AsyncHttpRequestHelper {
    private AsyncHttpRequestHelper() {
    }

    public static CompletableFuture<String> sendAsyncMetadataRequest(SdkAsyncHttpClient httpClient, SdkHttpFullRequest baseRequest, CompletableFuture<?> parentFuture) {
        return AsyncHttpRequestHelper.sendAsync(httpClient, baseRequest, AsyncHttpRequestHelper::handleResponse, parentFuture);
    }

    public static CompletableFuture<Token> sendAsyncTokenRequest(SdkAsyncHttpClient httpClient, SdkHttpFullRequest baseRequest) {
        return AsyncHttpRequestHelper.sendAsync(httpClient, baseRequest, AsyncHttpRequestHelper::handleTokenResponse, null);
    }

    private static <T> CompletableFuture<T> sendAsync(SdkAsyncHttpClient client, SdkHttpFullRequest request, HttpResponseHandler<T> handler, CompletableFuture<?> parentFuture) {
        SimpleHttpContentPublisher requestContentPublisher = new SimpleHttpContentPublisher(request);
        AsyncResponseHandler responseHandler = new AsyncResponseHandler(handler, Function.identity(), new ExecutionAttributes());
        CompletableFuture responseHandlerFuture = responseHandler.prepare();
        AsyncExecuteRequest metadataRequest = AsyncExecuteRequest.builder().request((SdkHttpRequest)request).requestContentPublisher((SdkHttpContentPublisher)requestContentPublisher).responseHandler((SdkAsyncHttpResponseHandler)responseHandler).build();
        CompletableFuture executeFuture = client.execute(metadataRequest);
        if (parentFuture != null) {
            CompletableFutureUtils.forwardExceptionTo(parentFuture, (CompletableFuture)executeFuture);
            CompletableFutureUtils.forwardExceptionTo(parentFuture, (CompletableFuture)responseHandlerFuture);
        }
        return responseHandlerFuture;
    }

    private static String handleResponse(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) {
        HttpStatusFamily statusCode = HttpStatusFamily.of((int)response.statusCode());
        AbortableInputStream inputStream = (AbortableInputStream)response.content().orElseThrow(() -> SdkClientException.create((String)"Unexpected error: empty response content"));
        String responseContent = BaseEc2MetadataClient.uncheckedInputStreamToUtf8(inputStream);
        if (statusCode.isOneOf(new HttpStatusFamily[]{HttpStatusFamily.SERVER_ERROR})) {
            throw RetryableException.create((String)responseContent);
        }
        if (!statusCode.isOneOf(new HttpStatusFamily[]{HttpStatusFamily.SUCCESSFUL})) {
            throw Ec2MetadataClientException.builder().statusCode(response.statusCode()).sdkHttpResponse((SdkHttpResponse)response).rawResponse(SdkBytes.fromUtf8String((String)responseContent)).message(String.format("Failed to send request to IMDS. Service returned %d error", response.statusCode())).build();
        }
        return responseContent;
    }

    private static Token handleTokenResponse(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) {
        String tokenValue = AsyncHttpRequestHelper.handleResponse(response, executionAttributes);
        Optional ttl = response.firstMatchingHeader("x-aws-ec2-metadata-token-ttl-seconds");
        if (!ttl.isPresent()) {
            throw SdkClientException.create((String)"x-aws-ec2-metadata-token-ttl-seconds header not found in token response");
        }
        try {
            Duration ttlDuration = Duration.ofSeconds(Long.parseLong((String)ttl.get()));
            return new Token(tokenValue, ttlDuration);
        }
        catch (NumberFormatException nfe) {
            throw SdkClientException.create((String)("Invalid token format received from IMDS server. Token received:  " + tokenValue), (Throwable)nfe);
        }
    }
}

