/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.imds.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.imds.internal.Token;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class AsyncTokenCache
implements Supplier<CompletableFuture<Token>> {
    private static final Logger log = Logger.loggerFor(AsyncTokenCache.class);
    private volatile Token cachedToken;
    private final Supplier<CompletableFuture<Token>> supplier;
    private Collection<CompletableFuture<Token>> waitingFutures = new ArrayList<CompletableFuture<Token>>();
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);
    private final Object refreshLock = new Object();

    AsyncTokenCache(Supplier<CompletableFuture<Token>> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Token> get() {
        Token currentValue = this.cachedToken;
        if (!this.needsRefresh(currentValue)) {
            log.debug(() -> "IMDS Token is not expired");
            return CompletableFuture.completedFuture(currentValue);
        }
        Object object = this.refreshLock;
        synchronized (object) {
            currentValue = this.cachedToken;
            if (!this.needsRefresh(currentValue)) {
                return CompletableFuture.completedFuture(currentValue);
            }
            CompletableFuture<Token> result = new CompletableFuture<Token>();
            this.waitingFutures.add(result);
            if (!this.refreshRunning.get()) {
                this.startRefresh();
            }
            return result;
        }
    }

    private void startRefresh() {
        log.debug(() -> "IMDS token expired or null, starting asynchronous refresh.");
        CompletableFuture<Token> tokenRequest = this.supplier.get();
        this.refreshRunning.set(true);
        tokenRequest.whenComplete((token, throwable) -> {
            Collection<CompletableFuture<Token>> toComplete;
            Object object = this.refreshLock;
            synchronized (object) {
                toComplete = this.waitingFutures;
                this.waitingFutures = new ArrayList<CompletableFuture<Token>>();
                this.refreshRunning.set(false);
                if (token != null) {
                    log.debug(() -> "IMDS token refresh completed. Token value: " + token.value());
                    this.cachedToken = token;
                } else {
                    log.error(() -> "IMDS token refresh completed with error.", throwable);
                }
            }
            toComplete.forEach(future -> {
                if (throwable == null) {
                    future.complete(token);
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
            });
        });
    }

    private boolean needsRefresh(Token token) {
        return token == null || token.isExpired();
    }
}

