/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.AccountListCopier;
import software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmiDistributionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmiDistributionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::name)).setter(AmiDistributionConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::description)).setter(AmiDistributionConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> TARGET_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetAccountIds").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::targetAccountIds)).setter(AmiDistributionConfiguration.setter(Builder::targetAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> AMI_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("amiTags").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::amiTags)).setter(AmiDistributionConfiguration.setter(Builder::amiTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::kmsKeyId)).setter(AmiDistributionConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<LaunchPermissionConfiguration> LAUNCH_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchPermission").getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::launchPermission)).setter(AmiDistributionConfiguration.setter(Builder::launchPermission)).constructor(LaunchPermissionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchPermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, TARGET_ACCOUNT_IDS_FIELD, AMI_TAGS_FIELD, KMS_KEY_ID_FIELD, LAUNCH_PERMISSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmiDistributionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> targetAccountIds;
    private final Map<String, String> amiTags;
    private final String kmsKeyId;
    private final LaunchPermissionConfiguration launchPermission;

    private AmiDistributionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.targetAccountIds = builder.targetAccountIds;
        this.amiTags = builder.amiTags;
        this.kmsKeyId = builder.kmsKeyId;
        this.launchPermission = builder.launchPermission;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargetAccountIds() {
        return this.targetAccountIds != null && !(this.targetAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> targetAccountIds() {
        return this.targetAccountIds;
    }

    public final boolean hasAmiTags() {
        return this.amiTags != null && !(this.amiTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> amiTags() {
        return this.amiTags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final LaunchPermissionConfiguration launchPermission() {
        return this.launchPermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetAccountIds() ? this.targetAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmiTags() ? this.amiTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermission());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiDistributionConfiguration)) {
            return false;
        }
        AmiDistributionConfiguration other = (AmiDistributionConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTargetAccountIds() == other.hasTargetAccountIds() && Objects.equals(this.targetAccountIds(), other.targetAccountIds()) && this.hasAmiTags() == other.hasAmiTags() && Objects.equals(this.amiTags(), other.amiTags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.launchPermission(), other.launchPermission());
    }

    public final String toString() {
        return ToString.builder((String)"AmiDistributionConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TargetAccountIds", this.hasTargetAccountIds() ? this.targetAccountIds() : null).add("AmiTags", this.hasAmiTags() ? this.amiTags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("LaunchPermission", (Object)this.launchPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targetAccountIds": {
                return Optional.ofNullable(clazz.cast(this.targetAccountIds()));
            }
            case "amiTags": {
                return Optional.ofNullable(clazz.cast(this.amiTags()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "launchPermission": {
                return Optional.ofNullable(clazz.cast(this.launchPermission()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetAccountIds", TARGET_ACCOUNT_IDS_FIELD);
        map.put("amiTags", AMI_TAGS_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("launchPermission", LAUNCH_PERMISSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmiDistributionConfiguration, T> g) {
        return obj -> g.apply((AmiDistributionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> targetAccountIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> amiTags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;
        private LaunchPermissionConfiguration launchPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiDistributionConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.targetAccountIds(model.targetAccountIds);
            this.amiTags(model.amiTags);
            this.kmsKeyId(model.kmsKeyId);
            this.launchPermission(model.launchPermission);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getTargetAccountIds() {
            if (this.targetAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetAccountIds;
        }

        public final void setTargetAccountIds(Collection<String> targetAccountIds) {
            this.targetAccountIds = AccountListCopier.copy(targetAccountIds);
        }

        @Override
        public final Builder targetAccountIds(Collection<String> targetAccountIds) {
            this.targetAccountIds = AccountListCopier.copy(targetAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetAccountIds(String ... targetAccountIds) {
            this.targetAccountIds(Arrays.asList(targetAccountIds));
            return this;
        }

        public final Map<String, String> getAmiTags() {
            if (this.amiTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.amiTags;
        }

        public final void setAmiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
        }

        @Override
        public final Builder amiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final LaunchPermissionConfiguration.Builder getLaunchPermission() {
            return this.launchPermission != null ? this.launchPermission.toBuilder() : null;
        }

        public final void setLaunchPermission(LaunchPermissionConfiguration.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionConfiguration launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public AmiDistributionConfiguration build() {
            return new AmiDistributionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmiDistributionConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder targetAccountIds(Collection<String> var1);

        public Builder targetAccountIds(String ... var1);

        public Builder amiTags(Map<String, String> var1);

        public Builder kmsKeyId(String var1);

        public Builder launchPermission(LaunchPermissionConfiguration var1);

        default public Builder launchPermission(Consumer<LaunchPermissionConfiguration.Builder> launchPermission) {
            return this.launchPermission((LaunchPermissionConfiguration)((LaunchPermissionConfiguration.Builder)LaunchPermissionConfiguration.builder().applyMutation(launchPermission)).build());
        }
    }
}

