/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.RegionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionConfigurationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::arn)).setter(DistributionConfigurationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::name)).setter(DistributionConfigurationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::description)).setter(DistributionConfigurationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::dateCreated)).setter(DistributionConfigurationSummary.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateUpdated").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::dateUpdated)).setter(DistributionConfigurationSummary.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::tags)).setter(DistributionConfigurationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(DistributionConfigurationSummary.getter(DistributionConfigurationSummary::regions)).setter(DistributionConfigurationSummary.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, TAGS_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DistributionConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String dateCreated;
    private final String dateUpdated;
    private final Map<String, String> tags;
    private final List<String> regions;

    private DistributionConfigurationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.tags = builder.tags;
        this.regions = builder.regions;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final String dateUpdated() {
        return this.dateUpdated;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfigurationSummary)) {
            return false;
        }
        DistributionConfigurationSummary other = (DistributionConfigurationSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"DistributionConfigurationSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Tags", this.hasTags() ? this.tags() : null).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "dateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("dateUpdated", DATE_UPDATED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionConfigurationSummary, T> g) {
        return obj -> g.apply((DistributionConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String dateCreated;
        private String dateUpdated;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfigurationSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.tags(model.tags);
            this.regions(model.regions);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final String getDateUpdated() {
            return this.dateUpdated;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public DistributionConfigurationSummary build() {
            return new DistributionConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionConfigurationSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dateCreated(String var1);

        public Builder dateUpdated(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

