/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails;
import software.amazon.awssdk.services.imagebuilder.model.PackageVulnerabilityDetails;
import software.amazon.awssdk.services.imagebuilder.model.Remediation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageScanFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageScanFinding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(ImageScanFinding.getter(ImageScanFinding::awsAccountId)).setter(ImageScanFinding.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageBuildVersionArn").getter(ImageScanFinding.getter(ImageScanFinding::imageBuildVersionArn)).setter(ImageScanFinding.setter(Builder::imageBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build()}).build();
    private static final SdkField<String> IMAGE_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imagePipelineArn").getter(ImageScanFinding.getter(ImageScanFinding::imagePipelineArn)).setter(ImageScanFinding.setter(Builder::imagePipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ImageScanFinding.getter(ImageScanFinding::type)).setter(ImageScanFinding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ImageScanFinding.getter(ImageScanFinding::description)).setter(ImageScanFinding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(ImageScanFinding.getter(ImageScanFinding::title)).setter(ImageScanFinding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remediation").getter(ImageScanFinding.getter(ImageScanFinding::remediation)).setter(ImageScanFinding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(ImageScanFinding.getter(ImageScanFinding::severity)).setter(ImageScanFinding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstObservedAt").getter(ImageScanFinding.getter(ImageScanFinding::firstObservedAt)).setter(ImageScanFinding.setter(Builder::firstObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ImageScanFinding.getter(ImageScanFinding::updatedAt)).setter(ImageScanFinding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Double> INSPECTOR_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("inspectorScore").getter(ImageScanFinding.getter(ImageScanFinding::inspectorScore)).setter(ImageScanFinding.setter(Builder::inspectorScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build()}).build();
    private static final SdkField<InspectorScoreDetails> INSPECTOR_SCORE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inspectorScoreDetails").getter(ImageScanFinding.getter(ImageScanFinding::inspectorScoreDetails)).setter(ImageScanFinding.setter(Builder::inspectorScoreDetails)).constructor(InspectorScoreDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScoreDetails").build()}).build();
    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageVulnerabilityDetails").getter(ImageScanFinding.getter(ImageScanFinding::packageVulnerabilityDetails)).setter(ImageScanFinding.setter(Builder::packageVulnerabilityDetails)).constructor(PackageVulnerabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails").build()}).build();
    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fixAvailable").getter(ImageScanFinding.getter(ImageScanFinding::fixAvailable)).setter(ImageScanFinding.setter(Builder::fixAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, IMAGE_PIPELINE_ARN_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, TITLE_FIELD, REMEDIATION_FIELD, SEVERITY_FIELD, FIRST_OBSERVED_AT_FIELD, UPDATED_AT_FIELD, INSPECTOR_SCORE_FIELD, INSPECTOR_SCORE_DETAILS_FIELD, PACKAGE_VULNERABILITY_DETAILS_FIELD, FIX_AVAILABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageScanFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String imageBuildVersionArn;
    private final String imagePipelineArn;
    private final String type;
    private final String description;
    private final String title;
    private final Remediation remediation;
    private final String severity;
    private final Instant firstObservedAt;
    private final Instant updatedAt;
    private final Double inspectorScore;
    private final InspectorScoreDetails inspectorScoreDetails;
    private final PackageVulnerabilityDetails packageVulnerabilityDetails;
    private final String fixAvailable;

    private ImageScanFinding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.imagePipelineArn = builder.imagePipelineArn;
        this.type = builder.type;
        this.description = builder.description;
        this.title = builder.title;
        this.remediation = builder.remediation;
        this.severity = builder.severity;
        this.firstObservedAt = builder.firstObservedAt;
        this.updatedAt = builder.updatedAt;
        this.inspectorScore = builder.inspectorScore;
        this.inspectorScoreDetails = builder.inspectorScoreDetails;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.fixAvailable = builder.fixAvailable;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String imageBuildVersionArn() {
        return this.imageBuildVersionArn;
    }

    public final String imagePipelineArn() {
        return this.imagePipelineArn;
    }

    public final String type() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String title() {
        return this.title;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final String severity() {
        return this.severity;
    }

    public final Instant firstObservedAt() {
        return this.firstObservedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Double inspectorScore() {
        return this.inspectorScore;
    }

    public final InspectorScoreDetails inspectorScoreDetails() {
        return this.inspectorScoreDetails;
    }

    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return this.packageVulnerabilityDetails;
    }

    public final String fixAvailable() {
        return this.fixAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFinding)) {
            return false;
        }
        ImageScanFinding other = (ImageScanFinding)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(this.imagePipelineArn(), other.imagePipelineArn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.firstObservedAt(), other.firstObservedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.inspectorScore(), other.inspectorScore()) && Objects.equals(this.inspectorScoreDetails(), other.inspectorScoreDetails()) && Objects.equals(this.packageVulnerabilityDetails(), other.packageVulnerabilityDetails()) && Objects.equals(this.fixAvailable(), other.fixAvailable());
    }

    public final String toString() {
        return ToString.builder((String)"ImageScanFinding").add("AwsAccountId", (Object)this.awsAccountId()).add("ImageBuildVersionArn", (Object)this.imageBuildVersionArn()).add("ImagePipelineArn", (Object)this.imagePipelineArn()).add("Type", (Object)this.type()).add("Description", (Object)this.description()).add("Title", (Object)this.title()).add("Remediation", (Object)this.remediation()).add("Severity", (Object)this.severity()).add("FirstObservedAt", (Object)this.firstObservedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("InspectorScore", (Object)this.inspectorScore()).add("InspectorScoreDetails", (Object)this.inspectorScoreDetails()).add("PackageVulnerabilityDetails", (Object)this.packageVulnerabilityDetails()).add("FixAvailable", (Object)this.fixAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "imageBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageBuildVersionArn()));
            }
            case "imagePipelineArn": {
                return Optional.ofNullable(clazz.cast(this.imagePipelineArn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "firstObservedAt": {
                return Optional.ofNullable(clazz.cast(this.firstObservedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "inspectorScore": {
                return Optional.ofNullable(clazz.cast(this.inspectorScore()));
            }
            case "inspectorScoreDetails": {
                return Optional.ofNullable(clazz.cast(this.inspectorScoreDetails()));
            }
            case "packageVulnerabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.packageVulnerabilityDetails()));
            }
            case "fixAvailable": {
                return Optional.ofNullable(clazz.cast(this.fixAvailable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("imagePipelineArn", IMAGE_PIPELINE_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("firstObservedAt", FIRST_OBSERVED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("inspectorScore", INSPECTOR_SCORE_FIELD);
        map.put("inspectorScoreDetails", INSPECTOR_SCORE_DETAILS_FIELD);
        map.put("packageVulnerabilityDetails", PACKAGE_VULNERABILITY_DETAILS_FIELD);
        map.put("fixAvailable", FIX_AVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFinding, T> g) {
        return obj -> g.apply((ImageScanFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String imageBuildVersionArn;
        private String imagePipelineArn;
        private String type;
        private String description;
        private String title;
        private Remediation remediation;
        private String severity;
        private Instant firstObservedAt;
        private Instant updatedAt;
        private Double inspectorScore;
        private InspectorScoreDetails inspectorScoreDetails;
        private PackageVulnerabilityDetails packageVulnerabilityDetails;
        private String fixAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFinding model) {
            this.awsAccountId(model.awsAccountId);
            this.imageBuildVersionArn(model.imageBuildVersionArn);
            this.imagePipelineArn(model.imagePipelineArn);
            this.type(model.type);
            this.description(model.description);
            this.title(model.title);
            this.remediation(model.remediation);
            this.severity(model.severity);
            this.firstObservedAt(model.firstObservedAt);
            this.updatedAt(model.updatedAt);
            this.inspectorScore(model.inspectorScore);
            this.inspectorScoreDetails(model.inspectorScoreDetails);
            this.packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            this.fixAvailable(model.fixAvailable);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return this.imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getImagePipelineArn() {
            return this.imagePipelineArn;
        }

        public final void setImagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
        }

        @Override
        public final Builder imagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return this.firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Double getInspectorScore() {
            return this.inspectorScore;
        }

        public final void setInspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
        }

        @Override
        public final Builder inspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
            return this;
        }

        public final InspectorScoreDetails.Builder getInspectorScoreDetails() {
            return this.inspectorScoreDetails != null ? this.inspectorScoreDetails.toBuilder() : null;
        }

        public final void setInspectorScoreDetails(InspectorScoreDetails.BuilderImpl inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails != null ? inspectorScoreDetails.build() : null;
        }

        @Override
        public final Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return this.packageVulnerabilityDetails != null ? this.packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final String getFixAvailable() {
            return this.fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        public ImageScanFinding build() {
            return new ImageScanFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageScanFinding> {
        public Builder awsAccountId(String var1);

        public Builder imageBuildVersionArn(String var1);

        public Builder imagePipelineArn(String var1);

        public Builder type(String var1);

        public Builder description(String var1);

        public Builder title(String var1);

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder severity(String var1);

        public Builder firstObservedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder inspectorScore(Double var1);

        public Builder inspectorScoreDetails(InspectorScoreDetails var1);

        default public Builder inspectorScoreDetails(Consumer<InspectorScoreDetails.Builder> inspectorScoreDetails) {
            return this.inspectorScoreDetails((InspectorScoreDetails)((InspectorScoreDetails.Builder)InspectorScoreDetails.builder().applyMutation(inspectorScoreDetails)).build());
        }

        public Builder packageVulnerabilityDetails(PackageVulnerabilityDetails var1);

        default public Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return this.packageVulnerabilityDetails((PackageVulnerabilityDetails)((PackageVulnerabilityDetails.Builder)PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)).build());
        }

        public Builder fixAvailable(String var1);
    }
}

