/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ComponentVersion;
import software.amazon.awssdk.services.imagebuilder.model.ComponentVersionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListComponentsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListComponentsResponse.getter(ListComponentsResponse::requestId)).setter(ListComponentsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ComponentVersion>> COMPONENT_VERSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentVersionList").getter(ListComponentsResponse.getter(ListComponentsResponse::componentVersionList)).setter(ListComponentsResponse.setter(Builder::componentVersionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComponentsResponse.getter(ListComponentsResponse::nextToken)).setter(ListComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, COMPONENT_VERSION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListComponentsResponse.memberNameToFieldInitializer();
    private final String requestIdValue;
    private final List<ComponentVersion> componentVersionList;
    private final String nextToken;

    private ListComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.componentVersionList = builder.componentVersionList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasComponentVersionList() {
        return this.componentVersionList != null && !(this.componentVersionList instanceof SdkAutoConstructList);
    }

    public final List<ComponentVersion> componentVersionList() {
        return this.componentVersionList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentVersionList() ? this.componentVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResponse)) {
            return false;
        }
        ListComponentsResponse other = (ListComponentsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasComponentVersionList() == other.hasComponentVersionList() && Objects.equals(this.componentVersionList(), other.componentVersionList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentsResponse").add("RequestId", (Object)this.requestId()).add("ComponentVersionList", this.hasComponentVersionList() ? this.componentVersionList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "componentVersionList": {
                return Optional.ofNullable(clazz.cast(this.componentVersionList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("componentVersionList", COMPONENT_VERSION_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsResponse, T> g) {
        return obj -> g.apply((ListComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ComponentVersion> componentVersionList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.componentVersionList(model.componentVersionList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<ComponentVersion.Builder> getComponentVersionList() {
            List<ComponentVersion.Builder> result = ComponentVersionListCopier.copyToBuilder(this.componentVersionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentVersionList(Collection<ComponentVersion.BuilderImpl> componentVersionList) {
            this.componentVersionList = ComponentVersionListCopier.copyFromBuilder(componentVersionList);
        }

        @Override
        public final Builder componentVersionList(Collection<ComponentVersion> componentVersionList) {
            this.componentVersionList = ComponentVersionListCopier.copy(componentVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersionList(ComponentVersion ... componentVersionList) {
            this.componentVersionList(Arrays.asList(componentVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersionList(Consumer<ComponentVersion.Builder> ... componentVersionList) {
            this.componentVersionList(Stream.of(componentVersionList).map(c -> (ComponentVersion)((ComponentVersion.Builder)ComponentVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComponentsResponse build() {
            return new ListComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentsResponse> {
        public Builder requestId(String var1);

        public Builder componentVersionList(Collection<ComponentVersion> var1);

        public Builder componentVersionList(ComponentVersion ... var1);

        public Builder componentVersionList(Consumer<ComponentVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

