/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageStatus {
    PENDING("PENDING"),
    CREATING("CREATING"),
    BUILDING("BUILDING"),
    TESTING("TESTING"),
    DISTRIBUTING("DISTRIBUTING"),
    INTEGRATING("INTEGRATING"),
    AVAILABLE("AVAILABLE"),
    CANCELLED("CANCELLED"),
    FAILED("FAILED"),
    DEPRECATED("DEPRECATED"),
    DELETED("DELETED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageStatus> VALUE_MAP;
    private final String value;

    private ImageStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageStatus> knownValues() {
        EnumSet<ImageStatus> knownValues = EnumSet.allOf(ImageStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageStatus.class, ImageStatus::toString);
    }
}

