/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.ResourceState;
import software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules;
import software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateIncludeResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartResourceStateUpdateRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, StartResourceStateUpdateRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::resourceArn)).setter(StartResourceStateUpdateRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<ResourceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::state)).setter(StartResourceStateUpdateRequest.setter(Builder::state)).constructor(ResourceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::executionRole)).setter(StartResourceStateUpdateRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<ResourceStateUpdateIncludeResources> INCLUDE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includeResources").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::includeResources)).setter(StartResourceStateUpdateRequest.setter(Builder::includeResources)).constructor(ResourceStateUpdateIncludeResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResources").build()}).build();
    private static final SdkField<ResourceStateUpdateExclusionRules> EXCLUSION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exclusionRules").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::exclusionRules)).setter(StartResourceStateUpdateRequest.setter(Builder::exclusionRules)).constructor(ResourceStateUpdateExclusionRules::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionRules").build()}).build();
    private static final SdkField<Instant> UPDATE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateAt").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::updateAt)).setter(StartResourceStateUpdateRequest.setter(Builder::updateAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateAt").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartResourceStateUpdateRequest.getter(StartResourceStateUpdateRequest::clientToken)).setter(StartResourceStateUpdateRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, STATE_FIELD, EXECUTION_ROLE_FIELD, INCLUDE_RESOURCES_FIELD, EXCLUSION_RULES_FIELD, UPDATE_AT_FIELD, CLIENT_TOKEN_FIELD));
    private final String resourceArn;
    private final ResourceState state;
    private final String executionRole;
    private final ResourceStateUpdateIncludeResources includeResources;
    private final ResourceStateUpdateExclusionRules exclusionRules;
    private final Instant updateAt;
    private final String clientToken;

    private StartResourceStateUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.state = builder.state;
        this.executionRole = builder.executionRole;
        this.includeResources = builder.includeResources;
        this.exclusionRules = builder.exclusionRules;
        this.updateAt = builder.updateAt;
        this.clientToken = builder.clientToken;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResourceState state() {
        return this.state;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final ResourceStateUpdateIncludeResources includeResources() {
        return this.includeResources;
    }

    public final ResourceStateUpdateExclusionRules exclusionRules() {
        return this.exclusionRules;
    }

    public final Instant updateAt() {
        return this.updateAt;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceStateUpdateRequest)) {
            return false;
        }
        StartResourceStateUpdateRequest other = (StartResourceStateUpdateRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.includeResources(), other.includeResources()) && Objects.equals(this.exclusionRules(), other.exclusionRules()) && Objects.equals(this.updateAt(), other.updateAt()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartResourceStateUpdateRequest").add("ResourceArn", (Object)this.resourceArn()).add("State", (Object)this.state()).add("ExecutionRole", (Object)this.executionRole()).add("IncludeResources", (Object)this.includeResources()).add("ExclusionRules", (Object)this.exclusionRules()).add("UpdateAt", (Object)this.updateAt()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "includeResources": {
                return Optional.ofNullable(clazz.cast(this.includeResources()));
            }
            case "exclusionRules": {
                return Optional.ofNullable(clazz.cast(this.exclusionRules()));
            }
            case "updateAt": {
                return Optional.ofNullable(clazz.cast(this.updateAt()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartResourceStateUpdateRequest, T> g) {
        return obj -> g.apply((StartResourceStateUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private ResourceState state;
        private String executionRole;
        private ResourceStateUpdateIncludeResources includeResources;
        private ResourceStateUpdateExclusionRules exclusionRules;
        private Instant updateAt;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceStateUpdateRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.state(model.state);
            this.executionRole(model.executionRole);
            this.includeResources(model.includeResources);
            this.exclusionRules(model.exclusionRules);
            this.updateAt(model.updateAt);
            this.clientToken(model.clientToken);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ResourceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ResourceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state = state;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final ResourceStateUpdateIncludeResources.Builder getIncludeResources() {
            return this.includeResources != null ? this.includeResources.toBuilder() : null;
        }

        public final void setIncludeResources(ResourceStateUpdateIncludeResources.BuilderImpl includeResources) {
            this.includeResources = includeResources != null ? includeResources.build() : null;
        }

        @Override
        public final Builder includeResources(ResourceStateUpdateIncludeResources includeResources) {
            this.includeResources = includeResources;
            return this;
        }

        public final ResourceStateUpdateExclusionRules.Builder getExclusionRules() {
            return this.exclusionRules != null ? this.exclusionRules.toBuilder() : null;
        }

        public final void setExclusionRules(ResourceStateUpdateExclusionRules.BuilderImpl exclusionRules) {
            this.exclusionRules = exclusionRules != null ? exclusionRules.build() : null;
        }

        @Override
        public final Builder exclusionRules(ResourceStateUpdateExclusionRules exclusionRules) {
            this.exclusionRules = exclusionRules;
            return this;
        }

        public final Instant getUpdateAt() {
            return this.updateAt;
        }

        public final void setUpdateAt(Instant updateAt) {
            this.updateAt = updateAt;
        }

        @Override
        public final Builder updateAt(Instant updateAt) {
            this.updateAt = updateAt;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceStateUpdateRequest build() {
            return new StartResourceStateUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartResourceStateUpdateRequest> {
        public Builder resourceArn(String var1);

        public Builder state(ResourceState var1);

        default public Builder state(Consumer<ResourceState.Builder> state) {
            return this.state((ResourceState)((ResourceState.Builder)ResourceState.builder().applyMutation(state)).build());
        }

        public Builder executionRole(String var1);

        public Builder includeResources(ResourceStateUpdateIncludeResources var1);

        default public Builder includeResources(Consumer<ResourceStateUpdateIncludeResources.Builder> includeResources) {
            return this.includeResources((ResourceStateUpdateIncludeResources)((ResourceStateUpdateIncludeResources.Builder)ResourceStateUpdateIncludeResources.builder().applyMutation(includeResources)).build());
        }

        public Builder exclusionRules(ResourceStateUpdateExclusionRules var1);

        default public Builder exclusionRules(Consumer<ResourceStateUpdateExclusionRules.Builder> exclusionRules) {
            return this.exclusionRules((ResourceStateUpdateExclusionRules)((ResourceStateUpdateExclusionRules.Builder)ResourceStateUpdateExclusionRules.builder().applyMutation(exclusionRules)).build());
        }

        public Builder updateAt(Instant var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

