/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Container.getter(Container::region)).setter(Container.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<String>> IMAGE_URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageUris").getter(Container.getter(Container::imageUris)).setter(Container.setter(Builder::imageUris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, IMAGE_URIS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String region;
    private final List<String> imageUris;

    private Container(BuilderImpl builder) {
        this.region = builder.region;
        this.imageUris = builder.imageUris;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasImageUris() {
        return this.imageUris != null && !(this.imageUris instanceof SdkAutoConstructList);
    }

    public final List<String> imageUris() {
        return this.imageUris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageUris() ? this.imageUris() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.region(), other.region()) && this.hasImageUris() == other.hasImageUris() && Objects.equals(this.imageUris(), other.imageUris());
    }

    public final String toString() {
        return ToString.builder((String)"Container").add("Region", (Object)this.region()).add("ImageUris", this.hasImageUris() ? this.imageUris() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "imageUris": {
                return Optional.ofNullable(clazz.cast(this.imageUris()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private List<String> imageUris = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.region(model.region);
            this.imageUris(model.imageUris);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getImageUris() {
            if (this.imageUris instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageUris;
        }

        public final void setImageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
        }

        @Override
        public final Builder imageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUris(String ... imageUris) {
            this.imageUris(Arrays.asList(imageUris));
            return this;
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder region(String var1);

        public Builder imageUris(Collection<String> var1);

        public Builder imageUris(String ... var1);
    }
}

