/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ComponentSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;

public class ListComponentBuildVersionsIterable
implements SdkIterable<ListComponentBuildVersionsResponse> {
    private final ImagebuilderClient client;
    private final ListComponentBuildVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentBuildVersionsIterable(ImagebuilderClient client, ListComponentBuildVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComponentBuildVersionsResponseFetcher();
    }

    public Iterator<ListComponentBuildVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComponentSummary> componentSummaryList() {
        Function<ListComponentBuildVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.componentSummaryList() != null) {
                return response.componentSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComponentBuildVersionsResponseFetcher
    implements SyncPageFetcher<ListComponentBuildVersionsResponse> {
        private ListComponentBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentBuildVersionsResponse nextPage(ListComponentBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentBuildVersionsIterable.this.client.listComponentBuildVersions(ListComponentBuildVersionsIterable.this.firstRequest);
            }
            return ListComponentBuildVersionsIterable.this.client.listComponentBuildVersions((ListComponentBuildVersionsRequest)((Object)ListComponentBuildVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

