/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourceListCopier;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLifecycleExecutionResourcesResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListLifecycleExecutionResourcesResponse> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleExecutionId").getter(ListLifecycleExecutionResourcesResponse.getter(ListLifecycleExecutionResourcesResponse::lifecycleExecutionId)).setter(ListLifecycleExecutionResourcesResponse.setter(Builder::lifecycleExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build()}).build();
    private static final SdkField<LifecycleExecutionState> LIFECYCLE_EXECUTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycleExecutionState").getter(ListLifecycleExecutionResourcesResponse.getter(ListLifecycleExecutionResourcesResponse::lifecycleExecutionState)).setter(ListLifecycleExecutionResourcesResponse.setter(Builder::lifecycleExecutionState)).constructor(LifecycleExecutionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionState").build()}).build();
    private static final SdkField<List<LifecycleExecutionResource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(ListLifecycleExecutionResourcesResponse.getter(ListLifecycleExecutionResourcesResponse::resources)).setter(ListLifecycleExecutionResourcesResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleExecutionResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLifecycleExecutionResourcesResponse.getter(ListLifecycleExecutionResourcesResponse::nextToken)).setter(ListLifecycleExecutionResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD, LIFECYCLE_EXECUTION_STATE_FIELD, RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final String lifecycleExecutionId;
    private final LifecycleExecutionState lifecycleExecutionState;
    private final List<LifecycleExecutionResource> resources;
    private final String nextToken;

    private ListLifecycleExecutionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.lifecycleExecutionState = builder.lifecycleExecutionState;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
    }

    public final String lifecycleExecutionId() {
        return this.lifecycleExecutionId;
    }

    public final LifecycleExecutionState lifecycleExecutionState() {
        return this.lifecycleExecutionState;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<LifecycleExecutionResource> resources() {
        return this.resources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecycleExecutionResourcesResponse)) {
            return false;
        }
        ListLifecycleExecutionResourcesResponse other = (ListLifecycleExecutionResourcesResponse)((Object)obj);
        return Objects.equals(this.lifecycleExecutionId(), other.lifecycleExecutionId()) && Objects.equals(this.lifecycleExecutionState(), other.lifecycleExecutionState()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLifecycleExecutionResourcesResponse").add("LifecycleExecutionId", (Object)this.lifecycleExecutionId()).add("LifecycleExecutionState", (Object)this.lifecycleExecutionState()).add("Resources", this.hasResources() ? this.resources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleExecutionId": {
                return Optional.ofNullable(clazz.cast(this.lifecycleExecutionId()));
            }
            case "lifecycleExecutionState": {
                return Optional.ofNullable(clazz.cast(this.lifecycleExecutionState()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLifecycleExecutionResourcesResponse, T> g) {
        return obj -> g.apply((ListLifecycleExecutionResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String lifecycleExecutionId;
        private LifecycleExecutionState lifecycleExecutionState;
        private List<LifecycleExecutionResource> resources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecycleExecutionResourcesResponse model) {
            super(model);
            this.lifecycleExecutionId(model.lifecycleExecutionId);
            this.lifecycleExecutionState(model.lifecycleExecutionState);
            this.resources(model.resources);
            this.nextToken(model.nextToken);
        }

        public final String getLifecycleExecutionId() {
            return this.lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final LifecycleExecutionState.Builder getLifecycleExecutionState() {
            return this.lifecycleExecutionState != null ? this.lifecycleExecutionState.toBuilder() : null;
        }

        public final void setLifecycleExecutionState(LifecycleExecutionState.BuilderImpl lifecycleExecutionState) {
            this.lifecycleExecutionState = lifecycleExecutionState != null ? lifecycleExecutionState.build() : null;
        }

        @Override
        public final Builder lifecycleExecutionState(LifecycleExecutionState lifecycleExecutionState) {
            this.lifecycleExecutionState = lifecycleExecutionState;
            return this;
        }

        public final List<LifecycleExecutionResource.Builder> getResources() {
            List<LifecycleExecutionResource.Builder> result = LifecycleExecutionResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<LifecycleExecutionResource.BuilderImpl> resources) {
            this.resources = LifecycleExecutionResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<LifecycleExecutionResource> resources) {
            this.resources = LifecycleExecutionResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(LifecycleExecutionResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<LifecycleExecutionResource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (LifecycleExecutionResource)((LifecycleExecutionResource.Builder)LifecycleExecutionResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLifecycleExecutionResourcesResponse build() {
            return new ListLifecycleExecutionResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLifecycleExecutionResourcesResponse> {
        public Builder lifecycleExecutionId(String var1);

        public Builder lifecycleExecutionState(LifecycleExecutionState var1);

        default public Builder lifecycleExecutionState(Consumer<LifecycleExecutionState.Builder> lifecycleExecutionState) {
            return this.lifecycleExecutionState((LifecycleExecutionState)((LifecycleExecutionState.Builder)LifecycleExecutionState.builder().applyMutation(lifecycleExecutionState)).build());
        }

        public Builder resources(Collection<LifecycleExecutionResource> var1);

        public Builder resources(LifecycleExecutionResource ... var1);

        public Builder resources(Consumer<LifecycleExecutionResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

