/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata;

public class ListWorkflowStepExecutionsIterable
implements SdkIterable<ListWorkflowStepExecutionsResponse> {
    private final ImagebuilderClient client;
    private final ListWorkflowStepExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowStepExecutionsIterable(ImagebuilderClient client, ListWorkflowStepExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkflowStepExecutionsResponseFetcher();
    }

    public Iterator<ListWorkflowStepExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowStepMetadata> steps() {
        Function<ListWorkflowStepExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowStepExecutionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowStepExecutionsResponse> {
        private ListWorkflowStepExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowStepExecutionsResponse nextPage(ListWorkflowStepExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepExecutionsIterable.this.client.listWorkflowStepExecutions(ListWorkflowStepExecutionsIterable.this.firstRequest);
            }
            return ListWorkflowStepExecutionsIterable.this.client.listWorkflowStepExecutions((ListWorkflowStepExecutionsRequest)((Object)ListWorkflowStepExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

