/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata;

public class ListWorkflowExecutionsPublisher
implements SdkPublisher<ListWorkflowExecutionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListWorkflowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowExecutionsPublisher(ImagebuilderAsyncClient client, ListWorkflowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowExecutionsPublisher(ImagebuilderAsyncClient client, ListWorkflowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowExecutionMetadata> workflowExecutions() {
        Function<ListWorkflowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowExecutions() != null) {
                return response.workflowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowExecutionsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowExecutionsResponse> {
        private ListWorkflowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowExecutionsResponse> nextPage(ListWorkflowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowExecutionsPublisher.this.client.listWorkflowExecutions(ListWorkflowExecutionsPublisher.this.firstRequest);
            }
            return ListWorkflowExecutionsPublisher.this.client.listWorkflowExecutions((ListWorkflowExecutionsRequest)((Object)ListWorkflowExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

