/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.imagebuilder.DefaultImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.DefaultImagebuilderBaseClientBuilder;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClientBuilder;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderServiceClientConfiguration;
import software.amazon.awssdk.services.imagebuilder.endpoints.ImagebuilderEndpointProvider;

@SdkInternalApi
final class DefaultImagebuilderAsyncClientBuilder
extends DefaultImagebuilderBaseClientBuilder<ImagebuilderAsyncClientBuilder, ImagebuilderAsyncClient>
implements ImagebuilderAsyncClientBuilder {
    DefaultImagebuilderAsyncClientBuilder() {
    }

    @Override
    public DefaultImagebuilderAsyncClientBuilder endpointProvider(ImagebuilderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ImagebuilderAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultImagebuilderAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ImagebuilderServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultImagebuilderAsyncClient client = new DefaultImagebuilderAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ImagebuilderServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ImagebuilderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

