/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.imagebuilder.DefaultImagebuilderBaseClientBuilder;
import software.amazon.awssdk.services.imagebuilder.DefaultImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClientBuilder;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderServiceClientConfiguration;
import software.amazon.awssdk.services.imagebuilder.endpoints.ImagebuilderEndpointProvider;

@SdkInternalApi
final class DefaultImagebuilderClientBuilder
extends DefaultImagebuilderBaseClientBuilder<ImagebuilderClientBuilder, ImagebuilderClient>
implements ImagebuilderClientBuilder {
    DefaultImagebuilderClientBuilder() {
    }

    @Override
    public DefaultImagebuilderClientBuilder endpointProvider(ImagebuilderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ImagebuilderClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultImagebuilderClientBuilder.validateClientOptions(clientConfiguration);
        ImagebuilderServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultImagebuilderClient client = new DefaultImagebuilderClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ImagebuilderServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ImagebuilderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

