/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instance metadata options that apply to the HTTP requests that pipeline builds use to launch EC2 build and test
 * instances. For more information about instance metadata options, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the
 * instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances, or <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure
 * the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMetadataOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMetadataOptions.Builder, InstanceMetadataOptions> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpTokens").getter(getter(InstanceMetadataOptions::httpTokens)).setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTokens").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("httpPutResponseHopLimit")
            .getter(getter(InstanceMetadataOptions::httpPutResponseHopLimit)).setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpPutResponseHopLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD,
            HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpTokens;

    private final Integer httpPutResponseHopLimit;

    private InstanceMetadataOptions(BuilderImpl builder) {
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
    }

    /**
     * <p>
     * Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect
     * the response as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>required</b> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all cases.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>optional</b> – You can include a signed token header in your request to retrieve instance metadata, or you can
     * leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise, version 1.0
     * credentials are returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is <b>optional</b>.
     * </p>
     * 
     * @return Indicates whether a signed token header is required for instance metadata retrieval requests. The values
     *         affect the response as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>required</b> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all
     *         cases.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>optional</b> – You can include a signed token header in your request to retrieve instance metadata, or
     *         you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role.
     *         Otherwise, version 1.0 credentials are returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is <b>optional</b>.
     */
    public final String httpTokens() {
        return httpTokens;
    }

    /**
     * <p>
     * Limit the number of hops that an instance metadata request can traverse to reach its destination. The default is
     * one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
     * </p>
     * 
     * @return Limit the number of hops that an instance metadata request can traverse to reach its destination. The
     *         default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two
     *         hops.
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpTokens());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataOptions)) {
            return false;
        }
        InstanceMetadataOptions other = (InstanceMetadataOptions) obj;
        return Objects.equals(httpTokens(), other.httpTokens())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMetadataOptions").add("HttpTokens", httpTokens())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpTokens":
            return Optional.ofNullable(clazz.cast(httpTokens()));
        case "httpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataOptions, T> g) {
        return obj -> g.apply((InstanceMetadataOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMetadataOptions> {
        /**
         * <p>
         * Indicates whether a signed token header is required for instance metadata retrieval requests. The values
         * affect the response as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>required</b> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in all
         * cases.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>optional</b> – You can include a signed token header in your request to retrieve instance metadata, or you
         * can leave it out. If you include it, version 2.0 credentials are returned for the IAM role. Otherwise,
         * version 1.0 credentials are returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is <b>optional</b>.
         * </p>
         * 
         * @param httpTokens
         *        Indicates whether a signed token header is required for instance metadata retrieval requests. The
         *        values affect the response as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>required</b> – When you retrieve the IAM role credentials, version 2.0 credentials are returned in
         *        all cases.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>optional</b> – You can include a signed token header in your request to retrieve instance metadata,
         *        or you can leave it out. If you include it, version 2.0 credentials are returned for the IAM role.
         *        Otherwise, version 1.0 credentials are returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is <b>optional</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * Limit the number of hops that an instance metadata request can traverse to reach its destination. The default
         * is one hop. However, if HTTP tokens are required, container image builds need a minimum of two hops.
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        Limit the number of hops that an instance metadata request can traverse to reach its destination. The
         *        default is one hop. However, if HTTP tokens are required, container image builds need a minimum of two
         *        hops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);
    }

    static final class BuilderImpl implements Builder {
        private String httpTokens;

        private Integer httpPutResponseHopLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataOptions model) {
            httpTokens(model.httpTokens);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        @Override
        public InstanceMetadataOptions build() {
            return new InstanceMetadataOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
