/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In addition to your infrastructure configuration, these settings provide an extra layer of control over your build
 * instances. You can also specify commands to run on launch for all of your build instances.
 * </p>
 * <p>
 * Image Builder does not automatically install the Systems Manager agent on Windows instances. If your base image
 * includes the Systems Manager agent, then the AMI that you create will also include the agent. For Linux instances, if
 * the base image does not already include the Systems Manager agent, Image Builder installs it. For Linux instances
 * where Image Builder installs the Systems Manager agent, you can choose whether to keep it for the AMI that you
 * create.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalInstanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalInstanceConfiguration.Builder, AdditionalInstanceConfiguration> {
    private static final SdkField<SystemsManagerAgent> SYSTEMS_MANAGER_AGENT_FIELD = SdkField
            .<SystemsManagerAgent> builder(MarshallingType.SDK_POJO).memberName("systemsManagerAgent")
            .getter(getter(AdditionalInstanceConfiguration::systemsManagerAgent)).setter(setter(Builder::systemsManagerAgent))
            .constructor(SystemsManagerAgent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemsManagerAgent").build())
            .build();

    private static final SdkField<String> USER_DATA_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userDataOverride").getter(getter(AdditionalInstanceConfiguration::userDataOverride))
            .setter(setter(Builder::userDataOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userDataOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEMS_MANAGER_AGENT_FIELD,
            USER_DATA_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SystemsManagerAgent systemsManagerAgent;

    private final String userDataOverride;

    private AdditionalInstanceConfiguration(BuilderImpl builder) {
        this.systemsManagerAgent = builder.systemsManagerAgent;
        this.userDataOverride = builder.userDataOverride;
    }

    /**
     * <p>
     * Contains settings for the Systems Manager agent on your build instance.
     * </p>
     * 
     * @return Contains settings for the Systems Manager agent on your build instance.
     */
    public final SystemsManagerAgent systemsManagerAgent() {
        return systemsManagerAgent;
    }

    /**
     * <p>
     * Use this property to provide commands or a command script to run when you launch your build instance.
     * </p>
     * <p>
     * The userDataOverride property replaces any commands that Image Builder might have added to ensure that Systems
     * Manager is installed on your Linux build instance. If you override the user data, make sure that you add commands
     * to install Systems Manager, if it is not pre-installed on your base image.
     * </p>
     * <note>
     * <p>
     * The user data is always base 64 encoded. For example, the following commands are encoded as
     * <code>IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$</code>:
     * </p>
     * <p>
     * <i>#!/bin/bash</i>
     * </p>
     * <p>
     * mkdir -p /var/bb/
     * </p>
     * <p>
     * touch /var
     * </p>
     * </note>
     * 
     * @return Use this property to provide commands or a command script to run when you launch your build instance.</p>
     *         <p>
     *         The userDataOverride property replaces any commands that Image Builder might have added to ensure that
     *         Systems Manager is installed on your Linux build instance. If you override the user data, make sure that
     *         you add commands to install Systems Manager, if it is not pre-installed on your base image.
     *         </p>
     *         <note>
     *         <p>
     *         The user data is always base 64 encoded. For example, the following commands are encoded as
     *         <code>IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$</code>:
     *         </p>
     *         <p>
     *         <i>#!/bin/bash</i>
     *         </p>
     *         <p>
     *         mkdir -p /var/bb/
     *         </p>
     *         <p>
     *         touch /var
     *         </p>
     */
    public final String userDataOverride() {
        return userDataOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(systemsManagerAgent());
        hashCode = 31 * hashCode + Objects.hashCode(userDataOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalInstanceConfiguration)) {
            return false;
        }
        AdditionalInstanceConfiguration other = (AdditionalInstanceConfiguration) obj;
        return Objects.equals(systemsManagerAgent(), other.systemsManagerAgent())
                && Objects.equals(userDataOverride(), other.userDataOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalInstanceConfiguration").add("SystemsManagerAgent", systemsManagerAgent())
                .add("UserDataOverride", userDataOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "systemsManagerAgent":
            return Optional.ofNullable(clazz.cast(systemsManagerAgent()));
        case "userDataOverride":
            return Optional.ofNullable(clazz.cast(userDataOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalInstanceConfiguration, T> g) {
        return obj -> g.apply((AdditionalInstanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalInstanceConfiguration> {
        /**
         * <p>
         * Contains settings for the Systems Manager agent on your build instance.
         * </p>
         * 
         * @param systemsManagerAgent
         *        Contains settings for the Systems Manager agent on your build instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemsManagerAgent(SystemsManagerAgent systemsManagerAgent);

        /**
         * <p>
         * Contains settings for the Systems Manager agent on your build instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemsManagerAgent.Builder} avoiding the
         * need to create one manually via {@link SystemsManagerAgent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SystemsManagerAgent.Builder#build()} is called immediately and
         * its result is passed to {@link #systemsManagerAgent(SystemsManagerAgent)}.
         * 
         * @param systemsManagerAgent
         *        a consumer that will call methods on {@link SystemsManagerAgent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemsManagerAgent(SystemsManagerAgent)
         */
        default Builder systemsManagerAgent(Consumer<SystemsManagerAgent.Builder> systemsManagerAgent) {
            return systemsManagerAgent(SystemsManagerAgent.builder().applyMutation(systemsManagerAgent).build());
        }

        /**
         * <p>
         * Use this property to provide commands or a command script to run when you launch your build instance.
         * </p>
         * <p>
         * The userDataOverride property replaces any commands that Image Builder might have added to ensure that
         * Systems Manager is installed on your Linux build instance. If you override the user data, make sure that you
         * add commands to install Systems Manager, if it is not pre-installed on your base image.
         * </p>
         * <note>
         * <p>
         * The user data is always base 64 encoded. For example, the following commands are encoded as
         * <code>IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$</code>:
         * </p>
         * <p>
         * <i>#!/bin/bash</i>
         * </p>
         * <p>
         * mkdir -p /var/bb/
         * </p>
         * <p>
         * touch /var
         * </p>
         * </note>
         * 
         * @param userDataOverride
         *        Use this property to provide commands or a command script to run when you launch your build
         *        instance.</p>
         *        <p>
         *        The userDataOverride property replaces any commands that Image Builder might have added to ensure that
         *        Systems Manager is installed on your Linux build instance. If you override the user data, make sure
         *        that you add commands to install Systems Manager, if it is not pre-installed on your base image.
         *        </p>
         *        <note>
         *        <p>
         *        The user data is always base 64 encoded. For example, the following commands are encoded as
         *        <code>IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$</code>:
         *        </p>
         *        <p>
         *        <i>#!/bin/bash</i>
         *        </p>
         *        <p>
         *        mkdir -p /var/bb/
         *        </p>
         *        <p>
         *        touch /var
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDataOverride(String userDataOverride);
    }

    static final class BuilderImpl implements Builder {
        private SystemsManagerAgent systemsManagerAgent;

        private String userDataOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalInstanceConfiguration model) {
            systemsManagerAgent(model.systemsManagerAgent);
            userDataOverride(model.userDataOverride);
        }

        public final SystemsManagerAgent.Builder getSystemsManagerAgent() {
            return systemsManagerAgent != null ? systemsManagerAgent.toBuilder() : null;
        }

        public final void setSystemsManagerAgent(SystemsManagerAgent.BuilderImpl systemsManagerAgent) {
            this.systemsManagerAgent = systemsManagerAgent != null ? systemsManagerAgent.build() : null;
        }

        @Override
        public final Builder systemsManagerAgent(SystemsManagerAgent systemsManagerAgent) {
            this.systemsManagerAgent = systemsManagerAgent;
            return this;
        }

        public final String getUserDataOverride() {
            return userDataOverride;
        }

        public final void setUserDataOverride(String userDataOverride) {
            this.userDataOverride = userDataOverride;
        }

        @Override
        public final Builder userDataOverride(String userDataOverride) {
            this.userDataOverride = userDataOverride;
            return this;
        }

        @Override
        public AdditionalInstanceConfiguration build() {
            return new AdditionalInstanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
