/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ImagePipeline;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;

public class ListImagePipelinesPublisher
implements SdkPublisher<ListImagePipelinesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImagePipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagePipelinesPublisher(ImagebuilderAsyncClient client, ListImagePipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagePipelinesPublisher(ImagebuilderAsyncClient client, ListImagePipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagePipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagePipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImagePipeline> imagePipelineList() {
        Function<ListImagePipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imagePipelineList() != null) {
                return response.imagePipelineList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImagePipelinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImagePipelinesResponseFetcher
    implements AsyncPageFetcher<ListImagePipelinesResponse> {
        private ListImagePipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImagePipelinesResponse> nextPage(ListImagePipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePipelinesPublisher.this.client.listImagePipelines(ListImagePipelinesPublisher.this.firstRequest);
            }
            return ListImagePipelinesPublisher.this.client.listImagePipelines((ListImagePipelinesRequest)((Object)ListImagePipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

