/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfigurationListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ContainerType;
import software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerRecipe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerRecipe> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ContainerRecipe.getter(ContainerRecipe::arn)).setter(ContainerRecipe.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerType").getter(ContainerRecipe.getter(ContainerRecipe::containerTypeAsString)).setter(ContainerRecipe.setter(Builder::containerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContainerRecipe.getter(ContainerRecipe::name)).setter(ContainerRecipe.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ContainerRecipe.getter(ContainerRecipe::description)).setter(ContainerRecipe.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ContainerRecipe.getter(ContainerRecipe::platformAsString)).setter(ContainerRecipe.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ContainerRecipe.getter(ContainerRecipe::owner)).setter(ContainerRecipe.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ContainerRecipe.getter(ContainerRecipe::version)).setter(ContainerRecipe.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("components").getter(ContainerRecipe.getter(ContainerRecipe::components)).setter(ContainerRecipe.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceConfiguration").getter(ContainerRecipe.getter(ContainerRecipe::instanceConfiguration)).setter(ContainerRecipe.setter(Builder::instanceConfiguration)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfiguration").build()}).build();
    private static final SdkField<String> DOCKERFILE_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dockerfileTemplateData").getter(ContainerRecipe.getter(ContainerRecipe::dockerfileTemplateData)).setter(ContainerRecipe.setter(Builder::dockerfileTemplateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateData").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ContainerRecipe.getter(ContainerRecipe::kmsKeyId)).setter(ContainerRecipe.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("encrypted").getter(ContainerRecipe.getter(ContainerRecipe::encrypted)).setter(ContainerRecipe.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentImage").getter(ContainerRecipe.getter(ContainerRecipe::parentImage)).setter(ContainerRecipe.setter(Builder::parentImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ContainerRecipe.getter(ContainerRecipe::dateCreated)).setter(ContainerRecipe.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ContainerRecipe.getter(ContainerRecipe::tags)).setter(ContainerRecipe.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workingDirectory").getter(ContainerRecipe.getter(ContainerRecipe::workingDirectory)).setter(ContainerRecipe.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()}).build();
    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetRepository").getter(ContainerRecipe.getter(ContainerRecipe::targetRepository)).setter(ContainerRecipe.setter(Builder::targetRepository)).constructor(TargetContainerRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTAINER_TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, OWNER_FIELD, VERSION_FIELD, COMPONENTS_FIELD, INSTANCE_CONFIGURATION_FIELD, DOCKERFILE_TEMPLATE_DATA_FIELD, KMS_KEY_ID_FIELD, ENCRYPTED_FIELD, PARENT_IMAGE_FIELD, DATE_CREATED_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD, TARGET_REPOSITORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String containerType;
    private final String name;
    private final String description;
    private final String platform;
    private final String owner;
    private final String version;
    private final List<ComponentConfiguration> components;
    private final InstanceConfiguration instanceConfiguration;
    private final String dockerfileTemplateData;
    private final String kmsKeyId;
    private final Boolean encrypted;
    private final String parentImage;
    private final String dateCreated;
    private final Map<String, String> tags;
    private final String workingDirectory;
    private final TargetContainerRepository targetRepository;

    private ContainerRecipe(BuilderImpl builder) {
        this.arn = builder.arn;
        this.containerType = builder.containerType;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.version = builder.version;
        this.components = builder.components;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.dockerfileTemplateData = builder.dockerfileTemplateData;
        this.kmsKeyId = builder.kmsKeyId;
        this.encrypted = builder.encrypted;
        this.parentImage = builder.parentImage;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.targetRepository = builder.targetRepository;
    }

    public final String arn() {
        return this.arn;
    }

    public final ContainerType containerType() {
        return ContainerType.fromValue(this.containerType);
    }

    public final String containerTypeAsString() {
        return this.containerType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String owner() {
        return this.owner;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<ComponentConfiguration> components() {
        return this.components;
    }

    public final InstanceConfiguration instanceConfiguration() {
        return this.instanceConfiguration;
    }

    public final String dockerfileTemplateData() {
        return this.dockerfileTemplateData;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String parentImage() {
        return this.parentImage;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final TargetContainerRepository targetRepository() {
        return this.targetRepository;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerfileTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRepository());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRecipe)) {
            return false;
        }
        ContainerRecipe other = (ContainerRecipe)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.version(), other.version()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.instanceConfiguration(), other.instanceConfiguration()) && Objects.equals(this.dockerfileTemplateData(), other.dockerfileTemplateData()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.parentImage(), other.parentImage()) && Objects.equals(this.dateCreated(), other.dateCreated()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.targetRepository(), other.targetRepository());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerRecipe").add("Arn", (Object)this.arn()).add("ContainerType", (Object)this.containerTypeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Platform", (Object)this.platformAsString()).add("Owner", (Object)this.owner()).add("Version", (Object)this.version()).add("Components", this.hasComponents() ? this.components() : null).add("InstanceConfiguration", (Object)this.instanceConfiguration()).add("DockerfileTemplateData", (Object)this.dockerfileTemplateData()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Encrypted", (Object)this.encrypted()).add("ParentImage", (Object)this.parentImage()).add("DateCreated", (Object)this.dateCreated()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkingDirectory", (Object)this.workingDirectory()).add("TargetRepository", (Object)this.targetRepository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "containerType": {
                return Optional.ofNullable(clazz.cast(this.containerTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "instanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceConfiguration()));
            }
            case "dockerfileTemplateData": {
                return Optional.ofNullable(clazz.cast(this.dockerfileTemplateData()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "parentImage": {
                return Optional.ofNullable(clazz.cast(this.parentImage()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "targetRepository": {
                return Optional.ofNullable(clazz.cast(this.targetRepository()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerRecipe, T> g) {
        return obj -> g.apply((ContainerRecipe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String containerType;
        private String name;
        private String description;
        private String platform;
        private String owner;
        private String version;
        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();
        private InstanceConfiguration instanceConfiguration;
        private String dockerfileTemplateData;
        private String kmsKeyId;
        private Boolean encrypted;
        private String parentImage;
        private String dateCreated;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workingDirectory;
        private TargetContainerRepository targetRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRecipe model) {
            this.arn(model.arn);
            this.containerType(model.containerType);
            this.name(model.name);
            this.description(model.description);
            this.platform(model.platform);
            this.owner(model.owner);
            this.version(model.version);
            this.components(model.components);
            this.instanceConfiguration(model.instanceConfiguration);
            this.dockerfileTemplateData(model.dockerfileTemplateData);
            this.kmsKeyId(model.kmsKeyId);
            this.encrypted(model.encrypted);
            this.parentImage(model.parentImage);
            this.dateCreated(model.dateCreated);
            this.tags(model.tags);
            this.workingDirectory(model.workingDirectory);
            this.targetRepository(model.targetRepository);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getContainerType() {
            return this.containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        @Transient
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        @Transient
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final List<ComponentConfiguration.Builder> getComponents() {
            List<ComponentConfiguration.Builder> result = ComponentConfigurationListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        @Override
        @Transient
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(ComponentConfiguration ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder> ... components) {
            this.components(Stream.of(components).map(c -> (ComponentConfiguration)((ComponentConfiguration.Builder)ComponentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return this.instanceConfiguration != null ? this.instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getDockerfileTemplateData() {
            return this.dockerfileTemplateData;
        }

        public final void setDockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
        }

        @Override
        @Transient
        public final Builder dockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getParentImage() {
            return this.parentImage;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        @Override
        @Transient
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return this.targetRepository != null ? this.targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        public ContainerRecipe build() {
            return new ContainerRecipe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerRecipe> {
        public Builder arn(String var1);

        public Builder containerType(String var1);

        public Builder containerType(ContainerType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder owner(String var1);

        public Builder version(String var1);

        public Builder components(Collection<ComponentConfiguration> var1);

        public Builder components(ComponentConfiguration ... var1);

        public Builder components(Consumer<ComponentConfiguration.Builder> ... var1);

        public Builder instanceConfiguration(InstanceConfiguration var1);

        default public Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return this.instanceConfiguration((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instanceConfiguration)).build());
        }

        public Builder dockerfileTemplateData(String var1);

        public Builder kmsKeyId(String var1);

        public Builder encrypted(Boolean var1);

        public Builder parentImage(String var1);

        public Builder dateCreated(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder workingDirectory(String var1);

        public Builder targetRepository(TargetContainerRepository var1);

        default public Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return this.targetRepository((TargetContainerRepository)((TargetContainerRepository.Builder)TargetContainerRepository.builder().applyMutation(targetRepository)).build());
        }
    }
}

