/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.Ami;
import software.amazon.awssdk.services.imagebuilder.model.AmiListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Container;
import software.amazon.awssdk.services.imagebuilder.model.ContainerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputResources> {
    private static final SdkField<List<Ami>> AMIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amis").getter(OutputResources.getter(OutputResources::amis)).setter(OutputResources.setter(Builder::amis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ami::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(OutputResources.getter(OutputResources::containers)).setter(OutputResources.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, CONTAINERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Ami> amis;
    private final List<Container> containers;

    private OutputResources(BuilderImpl builder) {
        this.amis = builder.amis;
        this.containers = builder.containers;
    }

    public final boolean hasAmis() {
        return this.amis != null && !(this.amis instanceof SdkAutoConstructList);
    }

    public final List<Ami> amis() {
        return this.amis;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<Container> containers() {
        return this.containers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmis() ? this.amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputResources)) {
            return false;
        }
        OutputResources other = (OutputResources)obj;
        return this.hasAmis() == other.hasAmis() && Objects.equals(this.amis(), other.amis()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers());
    }

    public final String toString() {
        return ToString.builder((String)"OutputResources").add("Amis", this.hasAmis() ? this.amis() : null).add("Containers", this.hasContainers() ? this.containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amis": {
                return Optional.ofNullable(clazz.cast(this.amis()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputResources, T> g) {
        return obj -> g.apply((OutputResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Ami> amis = DefaultSdkAutoConstructList.getInstance();
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputResources model) {
            this.amis(model.amis);
            this.containers(model.containers);
        }

        public final List<Ami.Builder> getAmis() {
            List<Ami.Builder> result = AmiListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<Ami.BuilderImpl> amis) {
            this.amis = AmiListCopier.copyFromBuilder(amis);
        }

        @Override
        @Transient
        public final Builder amis(Collection<Ami> amis) {
            this.amis = AmiListCopier.copy(amis);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder amis(Ami ... amis) {
            this.amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder amis(Consumer<Ami.Builder> ... amis) {
            this.amis(Stream.of(amis).map(c -> (Ami)((Ami.Builder)Ami.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainerListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainerListCopier.copyFromBuilder(containers);
        }

        @Override
        @Transient
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainerListCopier.copy(containers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (Container)((Container.Builder)Container.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OutputResources build() {
            return new OutputResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputResources> {
        public Builder amis(Collection<Ami> var1);

        public Builder amis(Ami ... var1);

        public Builder amis(Consumer<Ami.Builder> ... var1);

        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder containers(Consumer<Container.Builder> ... var1);
    }
}

