/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImageSummary;
import software.amazon.awssdk.services.imagebuilder.model.ImageSummaryListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageBuildVersionsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListImageBuildVersionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListImageBuildVersionsResponse.getter(ListImageBuildVersionsResponse::requestId)).setter(ListImageBuildVersionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ImageSummary>> IMAGE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageSummaryList").getter(ListImageBuildVersionsResponse.getter(ListImageBuildVersionsResponse::imageSummaryList)).setter(ListImageBuildVersionsResponse.setter(Builder::imageSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImageBuildVersionsResponse.getter(ListImageBuildVersionsResponse::nextToken)).setter(ListImageBuildVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<ImageSummary> imageSummaryList;
    private final String nextToken;

    private ListImageBuildVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageSummaryList = builder.imageSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasImageSummaryList() {
        return this.imageSummaryList != null && !(this.imageSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ImageSummary> imageSummaryList() {
        return this.imageSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageSummaryList() ? this.imageSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageBuildVersionsResponse)) {
            return false;
        }
        ListImageBuildVersionsResponse other = (ListImageBuildVersionsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasImageSummaryList() == other.hasImageSummaryList() && Objects.equals(this.imageSummaryList(), other.imageSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageBuildVersionsResponse").add("RequestId", (Object)this.requestId()).add("ImageSummaryList", this.hasImageSummaryList() ? this.imageSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imageSummaryList": {
                return Optional.ofNullable(clazz.cast(this.imageSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImageBuildVersionsResponse, T> g) {
        return obj -> g.apply((ListImageBuildVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ImageSummary> imageSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageBuildVersionsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imageSummaryList(model.imageSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<ImageSummary.Builder> getImageSummaryList() {
            if (this.imageSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageSummaryList != null ? (Collection)this.imageSummaryList.stream().map(ImageSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageSummaryList(Collection<ImageSummary> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copy(imageSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(ImageSummary ... imageSummaryList) {
            this.imageSummaryList(Arrays.asList(imageSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(Consumer<ImageSummary.Builder> ... imageSummaryList) {
            this.imageSummaryList(Stream.of(imageSummaryList).map(c -> (ImageSummary)((ImageSummary.Builder)ImageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageSummaryList(Collection<ImageSummary.BuilderImpl> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copyFromBuilder(imageSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImageBuildVersionsResponse build() {
            return new ListImageBuildVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImageBuildVersionsResponse> {
        public Builder requestId(String var1);

        public Builder imageSummaryList(Collection<ImageSummary> var1);

        public Builder imageSummaryList(ImageSummary ... var1);

        public Builder imageSummaryList(Consumer<ImageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

