/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;

public class ListImagePipelineImagesIterable
implements SdkIterable<ListImagePipelineImagesResponse> {
    private final ImagebuilderClient client;
    private final ListImagePipelineImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagePipelineImagesIterable(ImagebuilderClient client, ListImagePipelineImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImagePipelineImagesResponseFetcher();
    }

    public Iterator<ListImagePipelineImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImagePipelineImagesResponseFetcher
    implements SyncPageFetcher<ListImagePipelineImagesResponse> {
        private ListImagePipelineImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePipelineImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagePipelineImagesResponse nextPage(ListImagePipelineImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePipelineImagesIterable.this.client.listImagePipelineImages(ListImagePipelineImagesIterable.this.firstRequest);
            }
            return ListImagePipelineImagesIterable.this.client.listImagePipelineImages((ListImagePipelineImagesRequest)((Object)ListImagePipelineImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

