/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.OsVersionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateComponentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::name)).setter(CreateComponentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::semanticVersion)).setter(CreateComponentRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::description)).setter(CreateComponentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::changeDescription)).setter(CreateComponentRequest.setter(Builder::changeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::platformAsString)).setter(CreateComponentRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_OS_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateComponentRequest.getter(CreateComponentRequest::supportedOsVersions)).setter(CreateComponentRequest.setter(Builder::supportedOsVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOsVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::data)).setter(CreateComponentRequest.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::uri)).setter(CreateComponentRequest.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::kmsKeyId)).setter(CreateComponentRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateComponentRequest.getter(CreateComponentRequest::tags)).setter(CreateComponentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComponentRequest.getter(CreateComponentRequest::clientToken)).setter(CreateComponentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, PLATFORM_FIELD, SUPPORTED_OS_VERSIONS_FIELD, DATA_FIELD, URI_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String semanticVersion;
    private final String description;
    private final String changeDescription;
    private final String platform;
    private final List<String> supportedOsVersions;
    private final String data;
    private final String uri;
    private final String kmsKeyId;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.platform = builder.platform;
        this.supportedOsVersions = builder.supportedOsVersions;
        this.data = builder.data;
        this.uri = builder.uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public String name() {
        return this.name;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String description() {
        return this.description;
    }

    public String changeDescription() {
        return this.changeDescription;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public boolean hasSupportedOsVersions() {
        return this.supportedOsVersions != null && !(this.supportedOsVersions instanceof SdkAutoConstructList);
    }

    public List<String> supportedOsVersions() {
        return this.supportedOsVersions;
    }

    public String data() {
        return this.data;
    }

    public String uri() {
        return this.uri;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedOsVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.changeDescription(), other.changeDescription()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.supportedOsVersions(), other.supportedOsVersions()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateComponentRequest").add("Name", (Object)this.name()).add("SemanticVersion", (Object)this.semanticVersion()).add("Description", (Object)this.description()).add("ChangeDescription", (Object)this.changeDescription()).add("Platform", (Object)this.platformAsString()).add("SupportedOsVersions", this.supportedOsVersions()).add("Data", (Object)this.data()).add("Uri", (Object)this.uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.tags()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "semanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "changeDescription": {
                return Optional.ofNullable(clazz.cast(this.changeDescription()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "supportedOsVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedOsVersions()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String semanticVersion;
        private String description;
        private String changeDescription;
        private String platform;
        private List<String> supportedOsVersions = DefaultSdkAutoConstructList.getInstance();
        private String data;
        private String uri;
        private String kmsKeyId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            this.name(model.name);
            this.semanticVersion(model.semanticVersion);
            this.description(model.description);
            this.changeDescription(model.changeDescription);
            this.platform(model.platform);
            this.supportedOsVersions(model.supportedOsVersions);
            this.data(model.data);
            this.uri(model.uri);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getChangeDescription() {
            return this.changeDescription;
        }

        @Override
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<String> getSupportedOsVersions() {
            return this.supportedOsVersions;
        }

        @Override
        public final Builder supportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOsVersions(String ... supportedOsVersions) {
            this.supportedOsVersions(Arrays.asList(supportedOsVersions));
            return this;
        }

        public final void setSupportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentRequest> {
        public Builder name(String var1);

        public Builder semanticVersion(String var1);

        public Builder description(String var1);

        public Builder changeDescription(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder supportedOsVersions(Collection<String> var1);

        public Builder supportedOsVersions(String ... var1);

        public Builder data(String var1);

        public Builder uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

