/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmiDistributionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmiDistributionConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::name)).setter(AmiDistributionConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::description)).setter(AmiDistributionConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> AMI_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::amiTags)).setter(AmiDistributionConfiguration.setter(Builder::amiTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LaunchPermissionConfiguration> LAUNCH_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AmiDistributionConfiguration.getter(AmiDistributionConfiguration::launchPermission)).setter(AmiDistributionConfiguration.setter(Builder::launchPermission)).constructor(LaunchPermissionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchPermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, AMI_TAGS_FIELD, LAUNCH_PERMISSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Map<String, String> amiTags;
    private final LaunchPermissionConfiguration launchPermission;

    private AmiDistributionConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.amiTags = builder.amiTags;
        this.launchPermission = builder.launchPermission;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasAmiTags() {
        return this.amiTags != null && !(this.amiTags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> amiTags() {
        return this.amiTags;
    }

    public LaunchPermissionConfiguration launchPermission() {
        return this.launchPermission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermission());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiDistributionConfiguration)) {
            return false;
        }
        AmiDistributionConfiguration other = (AmiDistributionConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.amiTags(), other.amiTags()) && Objects.equals(this.launchPermission(), other.launchPermission());
    }

    public String toString() {
        return ToString.builder((String)"AmiDistributionConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AmiTags", this.amiTags()).add("LaunchPermission", (Object)this.launchPermission()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "amiTags": {
                return Optional.ofNullable(clazz.cast(this.amiTags()));
            }
            case "launchPermission": {
                return Optional.ofNullable(clazz.cast(this.launchPermission()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiDistributionConfiguration, T> g) {
        return obj -> g.apply((AmiDistributionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> amiTags = DefaultSdkAutoConstructMap.getInstance();
        private LaunchPermissionConfiguration launchPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiDistributionConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.amiTags(model.amiTags);
            this.launchPermission(model.launchPermission);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getAmiTags() {
            return this.amiTags;
        }

        @Override
        public final Builder amiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
            return this;
        }

        public final void setAmiTags(Map<String, String> amiTags) {
            this.amiTags = TagMapCopier.copy(amiTags);
        }

        public final LaunchPermissionConfiguration.Builder getLaunchPermission() {
            return this.launchPermission != null ? this.launchPermission.toBuilder() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionConfiguration launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final void setLaunchPermission(LaunchPermissionConfiguration.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        public AmiDistributionConfiguration build() {
            return new AmiDistributionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmiDistributionConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder amiTags(Map<String, String> var1);

        public Builder launchPermission(LaunchPermissionConfiguration var1);

        default public Builder launchPermission(Consumer<LaunchPermissionConfiguration.Builder> launchPermission) {
            return this.launchPermission((LaunchPermissionConfiguration)((LaunchPermissionConfiguration.Builder)LaunchPermissionConfiguration.builder().applyMutation(launchPermission)).build());
        }
    }
}

