/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;

public class ListImageBuildVersionsPublisher
implements SdkPublisher<ListImageBuildVersionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImageBuildVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageBuildVersionsPublisher(ImagebuilderAsyncClient client, ListImageBuildVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageBuildVersionsPublisher(ImagebuilderAsyncClient client, ListImageBuildVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageBuildVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageBuildVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImageBuildVersionsResponseFetcher
    implements AsyncPageFetcher<ListImageBuildVersionsResponse> {
        private ListImageBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageBuildVersionsResponse> nextPage(ListImageBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageBuildVersionsPublisher.this.client.listImageBuildVersions(ListImageBuildVersionsPublisher.this.firstRequest);
            }
            return ListImageBuildVersionsPublisher.this.client.listImageBuildVersions((ListImageBuildVersionsRequest)((Object)ListImageBuildVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

