/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInfrastructureConfigurationsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListInfrastructureConfigurationsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListInfrastructureConfigurationsResponse.getter(ListInfrastructureConfigurationsResponse::requestId)).setter(ListInfrastructureConfigurationsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<InfrastructureConfigurationSummary>> INFRASTRUCTURE_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListInfrastructureConfigurationsResponse.getter(ListInfrastructureConfigurationsResponse::infrastructureConfigurationSummaryList)).setter(ListInfrastructureConfigurationsResponse.setter(Builder::infrastructureConfigurationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InfrastructureConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListInfrastructureConfigurationsResponse.getter(ListInfrastructureConfigurationsResponse::nextToken)).setter(ListInfrastructureConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, INFRASTRUCTURE_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList;
    private final String nextToken;

    private ListInfrastructureConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.infrastructureConfigurationSummaryList = builder.infrastructureConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public boolean hasInfrastructureConfigurationSummaryList() {
        return this.infrastructureConfigurationSummaryList != null && !(this.infrastructureConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    public List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList() {
        return this.infrastructureConfigurationSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInfrastructureConfigurationsResponse)) {
            return false;
        }
        ListInfrastructureConfigurationsResponse other = (ListInfrastructureConfigurationsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.infrastructureConfigurationSummaryList(), other.infrastructureConfigurationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInfrastructureConfigurationsResponse").add("RequestId", (Object)this.requestId()).add("InfrastructureConfigurationSummaryList", this.infrastructureConfigurationSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "infrastructureConfigurationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInfrastructureConfigurationsResponse, T> g) {
        return obj -> g.apply((ListInfrastructureConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInfrastructureConfigurationsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.infrastructureConfigurationSummaryList(model.infrastructureConfigurationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<InfrastructureConfigurationSummary.Builder> getInfrastructureConfigurationSummaryList() {
            return this.infrastructureConfigurationSummaryList != null ? (Collection)this.infrastructureConfigurationSummaryList.stream().map(InfrastructureConfigurationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder infrastructureConfigurationSummaryList(Collection<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList = InfrastructureConfigurationSummaryListCopier.copy(infrastructureConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder infrastructureConfigurationSummaryList(InfrastructureConfigurationSummary ... infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList(Arrays.asList(infrastructureConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder infrastructureConfigurationSummaryList(Consumer<InfrastructureConfigurationSummary.Builder> ... infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList(Stream.of(infrastructureConfigurationSummaryList).map(c -> (InfrastructureConfigurationSummary)((InfrastructureConfigurationSummary.Builder)InfrastructureConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInfrastructureConfigurationSummaryList(Collection<InfrastructureConfigurationSummary.BuilderImpl> infrastructureConfigurationSummaryList) {
            this.infrastructureConfigurationSummaryList = InfrastructureConfigurationSummaryListCopier.copyFromBuilder(infrastructureConfigurationSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInfrastructureConfigurationsResponse build() {
            return new ListInfrastructureConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInfrastructureConfigurationsResponse> {
        public Builder requestId(String var1);

        public Builder infrastructureConfigurationSummaryList(Collection<InfrastructureConfigurationSummary> var1);

        public Builder infrastructureConfigurationSummaryList(InfrastructureConfigurationSummary ... var1);

        public Builder infrastructureConfigurationSummaryList(Consumer<InfrastructureConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

