/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImageState;
import software.amazon.awssdk.services.imagebuilder.model.OutputResources;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::arn)).setter(ImageSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::name)).setter(ImageSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::version)).setter(ImageSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::platformAsString)).setter(ImageSummary.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<ImageState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageSummary.getter(ImageSummary::state)).setter(ImageSummary.setter(Builder::state)).constructor(ImageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::owner)).setter(ImageSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageSummary.getter(ImageSummary::dateCreated)).setter(ImageSummary.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<OutputResources> OUTPUT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ImageSummary.getter(ImageSummary::outputResources)).setter(ImageSummary.setter(Builder::outputResources)).constructor(OutputResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputResources").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ImageSummary.getter(ImageSummary::tags)).setter(ImageSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, PLATFORM_FIELD, STATE_FIELD, OWNER_FIELD, DATE_CREATED_FIELD, OUTPUT_RESOURCES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String version;
    private final String platform;
    private final ImageState state;
    private final String owner;
    private final String dateCreated;
    private final OutputResources outputResources;
    private final Map<String, String> tags;

    private ImageSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.state = builder.state;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
        this.outputResources = builder.outputResources;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public ImageState state() {
        return this.state;
    }

    public String owner() {
        return this.owner;
    }

    public String dateCreated() {
        return this.dateCreated;
    }

    public OutputResources outputResources() {
        return this.outputResources;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSummary)) {
            return false;
        }
        ImageSummary other = (ImageSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.outputResources(), other.outputResources()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ImageSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("State", (Object)this.state()).add("Owner", (Object)this.owner()).add("DateCreated", (Object)this.dateCreated()).add("OutputResources", (Object)this.outputResources()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "outputResources": {
                return Optional.ofNullable(clazz.cast(this.outputResources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageSummary, T> g) {
        return obj -> g.apply((ImageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private String platform;
        private ImageState state;
        private String owner;
        private String dateCreated;
        private OutputResources outputResources;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.platform(model.platform);
            this.state(model.state);
            this.owner(model.owner);
            this.dateCreated(model.dateCreated);
            this.outputResources(model.outputResources);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getPlatformAsString() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final ImageState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final OutputResources.Builder getOutputResources() {
            return this.outputResources != null ? this.outputResources.toBuilder() : null;
        }

        @Override
        public final Builder outputResources(OutputResources outputResources) {
            this.outputResources = outputResources;
            return this;
        }

        public final void setOutputResources(OutputResources.BuilderImpl outputResources) {
            this.outputResources = outputResources != null ? outputResources.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public ImageSummary build() {
            return new ImageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder state(ImageState var1);

        default public Builder state(Consumer<ImageState.Builder> state) {
            return this.state((ImageState)((ImageState.Builder)ImageState.builder().applyMutation(state)).build());
        }

        public Builder owner(String var1);

        public Builder dateCreated(String var1);

        public Builder outputResources(OutputResources var1);

        default public Builder outputResources(Consumer<OutputResources.Builder> outputResources) {
            return this.outputResources((OutputResources)((OutputResources.Builder)OutputResources.builder().applyMutation(outputResources)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

