/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImageRecipe;
import software.amazon.awssdk.services.imagebuilder.model.ImageState;
import software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.OutputResources;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::arn)).setter(Image.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::name)).setter(Image.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::version)).setter(Image.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::platformAsString)).setter(Image.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<ImageState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::state)).setter(Image.setter(Builder::state)).constructor(ImageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<ImageRecipe> IMAGE_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::imageRecipe)).setter(Image.setter(Builder::imageRecipe)).constructor(ImageRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipe").build()}).build();
    private static final SdkField<String> SOURCE_PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::sourcePipelineName)).setter(Image.setter(Builder::sourcePipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePipelineName").build()}).build();
    private static final SdkField<String> SOURCE_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::sourcePipelineArn)).setter(Image.setter(Builder::sourcePipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePipelineArn").build()}).build();
    private static final SdkField<InfrastructureConfiguration> INFRASTRUCTURE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::infrastructureConfiguration)).setter(Image.setter(Builder::infrastructureConfiguration)).constructor(InfrastructureConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfiguration").build()}).build();
    private static final SdkField<DistributionConfiguration> DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::distributionConfiguration)).setter(Image.setter(Builder::distributionConfiguration)).constructor(DistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfiguration").build()}).build();
    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::imageTestsConfiguration)).setter(Image.setter(Builder::imageTestsConfiguration)).constructor(ImageTestsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::dateCreated)).setter(Image.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<OutputResources> OUTPUT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::outputResources)).setter(Image.setter(Builder::outputResources)).constructor(OutputResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputResources").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Image.getter(Image::tags)).setter(Image.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, PLATFORM_FIELD, STATE_FIELD, IMAGE_RECIPE_FIELD, SOURCE_PIPELINE_NAME_FIELD, SOURCE_PIPELINE_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_FIELD, DISTRIBUTION_CONFIGURATION_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, DATE_CREATED_FIELD, OUTPUT_RESOURCES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String version;
    private final String platform;
    private final ImageState state;
    private final ImageRecipe imageRecipe;
    private final String sourcePipelineName;
    private final String sourcePipelineArn;
    private final InfrastructureConfiguration infrastructureConfiguration;
    private final DistributionConfiguration distributionConfiguration;
    private final ImageTestsConfiguration imageTestsConfiguration;
    private final String dateCreated;
    private final OutputResources outputResources;
    private final Map<String, String> tags;

    private Image(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.state = builder.state;
        this.imageRecipe = builder.imageRecipe;
        this.sourcePipelineName = builder.sourcePipelineName;
        this.sourcePipelineArn = builder.sourcePipelineArn;
        this.infrastructureConfiguration = builder.infrastructureConfiguration;
        this.distributionConfiguration = builder.distributionConfiguration;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.dateCreated = builder.dateCreated;
        this.outputResources = builder.outputResources;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public ImageState state() {
        return this.state;
    }

    public ImageRecipe imageRecipe() {
        return this.imageRecipe;
    }

    public String sourcePipelineName() {
        return this.sourcePipelineName;
    }

    public String sourcePipelineArn() {
        return this.sourcePipelineArn;
    }

    public InfrastructureConfiguration infrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public DistributionConfiguration distributionConfiguration() {
        return this.distributionConfiguration;
    }

    public ImageTestsConfiguration imageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public String dateCreated() {
        return this.dateCreated;
    }

    public OutputResources outputResources() {
        return this.outputResources;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.imageRecipe(), other.imageRecipe()) && Objects.equals(this.sourcePipelineName(), other.sourcePipelineName()) && Objects.equals(this.sourcePipelineArn(), other.sourcePipelineArn()) && Objects.equals(this.infrastructureConfiguration(), other.infrastructureConfiguration()) && Objects.equals(this.distributionConfiguration(), other.distributionConfiguration()) && Objects.equals(this.imageTestsConfiguration(), other.imageTestsConfiguration()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.outputResources(), other.outputResources()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Image").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("State", (Object)this.state()).add("ImageRecipe", (Object)this.imageRecipe()).add("SourcePipelineName", (Object)this.sourcePipelineName()).add("SourcePipelineArn", (Object)this.sourcePipelineArn()).add("InfrastructureConfiguration", (Object)this.infrastructureConfiguration()).add("DistributionConfiguration", (Object)this.distributionConfiguration()).add("ImageTestsConfiguration", (Object)this.imageTestsConfiguration()).add("DateCreated", (Object)this.dateCreated()).add("OutputResources", (Object)this.outputResources()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "imageRecipe": {
                return Optional.ofNullable(clazz.cast(this.imageRecipe()));
            }
            case "sourcePipelineName": {
                return Optional.ofNullable(clazz.cast(this.sourcePipelineName()));
            }
            case "sourcePipelineArn": {
                return Optional.ofNullable(clazz.cast(this.sourcePipelineArn()));
            }
            case "infrastructureConfiguration": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfiguration()));
            }
            case "distributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.distributionConfiguration()));
            }
            case "imageTestsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageTestsConfiguration()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "outputResources": {
                return Optional.ofNullable(clazz.cast(this.outputResources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private String platform;
        private ImageState state;
        private ImageRecipe imageRecipe;
        private String sourcePipelineName;
        private String sourcePipelineArn;
        private InfrastructureConfiguration infrastructureConfiguration;
        private DistributionConfiguration distributionConfiguration;
        private ImageTestsConfiguration imageTestsConfiguration;
        private String dateCreated;
        private OutputResources outputResources;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.platform(model.platform);
            this.state(model.state);
            this.imageRecipe(model.imageRecipe);
            this.sourcePipelineName(model.sourcePipelineName);
            this.sourcePipelineArn(model.sourcePipelineArn);
            this.infrastructureConfiguration(model.infrastructureConfiguration);
            this.distributionConfiguration(model.distributionConfiguration);
            this.imageTestsConfiguration(model.imageTestsConfiguration);
            this.dateCreated(model.dateCreated);
            this.outputResources(model.outputResources);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getPlatformAsString() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final ImageState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final ImageRecipe.Builder getImageRecipe() {
            return this.imageRecipe != null ? this.imageRecipe.toBuilder() : null;
        }

        @Override
        public final Builder imageRecipe(ImageRecipe imageRecipe) {
            this.imageRecipe = imageRecipe;
            return this;
        }

        public final void setImageRecipe(ImageRecipe.BuilderImpl imageRecipe) {
            this.imageRecipe = imageRecipe != null ? imageRecipe.build() : null;
        }

        public final String getSourcePipelineName() {
            return this.sourcePipelineName;
        }

        @Override
        public final Builder sourcePipelineName(String sourcePipelineName) {
            this.sourcePipelineName = sourcePipelineName;
            return this;
        }

        public final void setSourcePipelineName(String sourcePipelineName) {
            this.sourcePipelineName = sourcePipelineName;
        }

        public final String getSourcePipelineArn() {
            return this.sourcePipelineArn;
        }

        @Override
        public final Builder sourcePipelineArn(String sourcePipelineArn) {
            this.sourcePipelineArn = sourcePipelineArn;
            return this;
        }

        public final void setSourcePipelineArn(String sourcePipelineArn) {
            this.sourcePipelineArn = sourcePipelineArn;
        }

        public final InfrastructureConfiguration.Builder getInfrastructureConfiguration() {
            return this.infrastructureConfiguration != null ? this.infrastructureConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder infrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration;
            return this;
        }

        public final void setInfrastructureConfiguration(InfrastructureConfiguration.BuilderImpl infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration != null ? infrastructureConfiguration.build() : null;
        }

        public final DistributionConfiguration.Builder getDistributionConfiguration() {
            return this.distributionConfiguration != null ? this.distributionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfiguration(DistributionConfiguration distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration;
            return this;
        }

        public final void setDistributionConfiguration(DistributionConfiguration.BuilderImpl distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration != null ? distributionConfiguration.build() : null;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return this.imageTestsConfiguration != null ? this.imageTestsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final OutputResources.Builder getOutputResources() {
            return this.outputResources != null ? this.outputResources.toBuilder() : null;
        }

        @Override
        public final Builder outputResources(OutputResources outputResources) {
            this.outputResources = outputResources;
            return this;
        }

        public final void setOutputResources(OutputResources.BuilderImpl outputResources) {
            this.outputResources = outputResources != null ? outputResources.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder state(ImageState var1);

        default public Builder state(Consumer<ImageState.Builder> state) {
            return this.state((ImageState)((ImageState.Builder)ImageState.builder().applyMutation(state)).build());
        }

        public Builder imageRecipe(ImageRecipe var1);

        default public Builder imageRecipe(Consumer<ImageRecipe.Builder> imageRecipe) {
            return this.imageRecipe((ImageRecipe)((ImageRecipe.Builder)ImageRecipe.builder().applyMutation(imageRecipe)).build());
        }

        public Builder sourcePipelineName(String var1);

        public Builder sourcePipelineArn(String var1);

        public Builder infrastructureConfiguration(InfrastructureConfiguration var1);

        default public Builder infrastructureConfiguration(Consumer<InfrastructureConfiguration.Builder> infrastructureConfiguration) {
            return this.infrastructureConfiguration((InfrastructureConfiguration)((InfrastructureConfiguration.Builder)InfrastructureConfiguration.builder().applyMutation(infrastructureConfiguration)).build());
        }

        public Builder distributionConfiguration(DistributionConfiguration var1);

        default public Builder distributionConfiguration(Consumer<DistributionConfiguration.Builder> distributionConfiguration) {
            return this.distributionConfiguration((DistributionConfiguration)((DistributionConfiguration.Builder)DistributionConfiguration.builder().applyMutation(distributionConfiguration)).build());
        }

        public Builder imageTestsConfiguration(ImageTestsConfiguration var1);

        default public Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return this.imageTestsConfiguration((ImageTestsConfiguration)((ImageTestsConfiguration.Builder)ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration)).build());
        }

        public Builder dateCreated(String var1);

        public Builder outputResources(OutputResources var1);

        default public Builder outputResources(Consumer<OutputResources.Builder> outputResources) {
            return this.outputResources((OutputResources)((OutputResources.Builder)OutputResources.builder().applyMutation(outputResources)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

