/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLastAccessed
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLastAccessed> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceLastAccessed.getter(ServiceLastAccessed::serviceName)).setter(ServiceLastAccessed.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Instant> LAST_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ServiceLastAccessed.getter(ServiceLastAccessed::lastAuthenticated)).setter(ServiceLastAccessed.setter(Builder::lastAuthenticated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticated").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceLastAccessed.getter(ServiceLastAccessed::serviceNamespace)).setter(ServiceLastAccessed.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> LAST_AUTHENTICATED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceLastAccessed.getter(ServiceLastAccessed::lastAuthenticatedEntity)).setter(ServiceLastAccessed.setter(Builder::lastAuthenticatedEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedEntity").build()}).build();
    private static final SdkField<Integer> TOTAL_AUTHENTICATED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ServiceLastAccessed.getter(ServiceLastAccessed::totalAuthenticatedEntities)).setter(ServiceLastAccessed.setter(Builder::totalAuthenticatedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAuthenticatedEntities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, LAST_AUTHENTICATED_FIELD, SERVICE_NAMESPACE_FIELD, LAST_AUTHENTICATED_ENTITY_FIELD, TOTAL_AUTHENTICATED_ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final Instant lastAuthenticated;
    private final String serviceNamespace;
    private final String lastAuthenticatedEntity;
    private final Integer totalAuthenticatedEntities;

    private ServiceLastAccessed(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.lastAuthenticated = builder.lastAuthenticated;
        this.serviceNamespace = builder.serviceNamespace;
        this.lastAuthenticatedEntity = builder.lastAuthenticatedEntity;
        this.totalAuthenticatedEntities = builder.totalAuthenticatedEntities;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Instant lastAuthenticated() {
        return this.lastAuthenticated;
    }

    public String serviceNamespace() {
        return this.serviceNamespace;
    }

    public String lastAuthenticatedEntity() {
        return this.lastAuthenticatedEntity;
    }

    public Integer totalAuthenticatedEntities() {
        return this.totalAuthenticatedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticatedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAuthenticatedEntities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLastAccessed)) {
            return false;
        }
        ServiceLastAccessed other = (ServiceLastAccessed)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.lastAuthenticated(), other.lastAuthenticated()) && Objects.equals(this.serviceNamespace(), other.serviceNamespace()) && Objects.equals(this.lastAuthenticatedEntity(), other.lastAuthenticatedEntity()) && Objects.equals(this.totalAuthenticatedEntities(), other.totalAuthenticatedEntities());
    }

    public String toString() {
        return ToString.builder((String)"ServiceLastAccessed").add("ServiceName", (Object)this.serviceName()).add("LastAuthenticated", (Object)this.lastAuthenticated()).add("ServiceNamespace", (Object)this.serviceNamespace()).add("LastAuthenticatedEntity", (Object)this.lastAuthenticatedEntity()).add("TotalAuthenticatedEntities", (Object)this.totalAuthenticatedEntities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "LastAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticated()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespace()));
            }
            case "LastAuthenticatedEntity": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticatedEntity()));
            }
            case "TotalAuthenticatedEntities": {
                return Optional.ofNullable(clazz.cast(this.totalAuthenticatedEntities()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLastAccessed, T> g) {
        return obj -> g.apply((ServiceLastAccessed)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private Instant lastAuthenticated;
        private String serviceNamespace;
        private String lastAuthenticatedEntity;
        private Integer totalAuthenticatedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLastAccessed model) {
            this.serviceName(model.serviceName);
            this.lastAuthenticated(model.lastAuthenticated);
            this.serviceNamespace(model.serviceNamespace);
            this.lastAuthenticatedEntity(model.lastAuthenticatedEntity);
            this.totalAuthenticatedEntities(model.totalAuthenticatedEntities);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Instant getLastAuthenticated() {
            return this.lastAuthenticated;
        }

        @Override
        public final Builder lastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
            return this;
        }

        public final void setLastAuthenticated(Instant lastAuthenticated) {
            this.lastAuthenticated = lastAuthenticated;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getLastAuthenticatedEntity() {
            return this.lastAuthenticatedEntity;
        }

        @Override
        public final Builder lastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
            return this;
        }

        public final void setLastAuthenticatedEntity(String lastAuthenticatedEntity) {
            this.lastAuthenticatedEntity = lastAuthenticatedEntity;
        }

        public final Integer getTotalAuthenticatedEntities() {
            return this.totalAuthenticatedEntities;
        }

        @Override
        public final Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
            return this;
        }

        public final void setTotalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
        }

        public ServiceLastAccessed build() {
            return new ServiceLastAccessed(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLastAccessed> {
        public Builder serviceName(String var1);

        public Builder lastAuthenticated(Instant var1);

        public Builder serviceNamespace(String var1);

        public Builder lastAuthenticatedEntity(String var1);

        public Builder totalAuthenticatedEntities(Integer var1);
    }
}

