/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PolicySourceType {
    USER("user"),
    GROUP("group"),
    ROLE("role"),
    AWS_MANAGED("aws-managed"),
    USER_MANAGED("user-managed"),
    RESOURCE("resource"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PolicySourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicySourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PolicySourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicySourceType> knownValues() {
        return Stream.of(PolicySourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

