/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyVersion> {
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyVersion.getter(PolicyVersion::document)).setter(PolicyVersion.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PolicyVersion.getter(PolicyVersion::versionId)).setter(PolicyVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PolicyVersion.getter(PolicyVersion::isDefaultVersion)).setter(PolicyVersion.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PolicyVersion.getter(PolicyVersion::createDate)).setter(PolicyVersion.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, CREATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String document;
    private final String versionId;
    private final Boolean isDefaultVersion;
    private final Instant createDate;

    private PolicyVersion(BuilderImpl builder) {
        this.document = builder.document;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.createDate = builder.createDate;
    }

    public String document() {
        return this.document;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyVersion)) {
            return false;
        }
        PolicyVersion other = (PolicyVersion)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        return ToString.builder((String)"PolicyVersion").add("Document", (Object)this.document()).add("VersionId", (Object)this.versionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("CreateDate", (Object)this.createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "IsDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyVersion, T> g) {
        return obj -> g.apply((PolicyVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String document;
        private String versionId;
        private Boolean isDefaultVersion;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyVersion model) {
            this.document(model.document);
            this.versionId(model.versionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.createDate(model.createDate);
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public PolicyVersion build() {
            return new PolicyVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyVersion> {
        public Builder document(String var1);

        public Builder versionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder createDate(Instant var1);
    }
}

