/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualMFADevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualMFADevice> {
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualMFADevice.getter(VirtualMFADevice::serialNumber)).setter(VirtualMFADevice.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<SdkBytes> BASE32_STRING_SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(VirtualMFADevice.getter(VirtualMFADevice::base32StringSeed)).setter(VirtualMFADevice.setter(Builder::base32StringSeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base32StringSeed").build()}).build();
    private static final SdkField<SdkBytes> QR_CODE_PNG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(VirtualMFADevice.getter(VirtualMFADevice::qrCodePNG)).setter(VirtualMFADevice.setter(Builder::qrCodePNG)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QRCodePNG").build()}).build();
    private static final SdkField<User> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualMFADevice.getter(VirtualMFADevice::user)).setter(VirtualMFADevice.setter(Builder::user)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<Instant> ENABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VirtualMFADevice.getter(VirtualMFADevice::enableDate)).setter(VirtualMFADevice.setter(Builder::enableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERIAL_NUMBER_FIELD, BASE32_STRING_SEED_FIELD, QR_CODE_PNG_FIELD, USER_FIELD, ENABLE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serialNumber;
    private final SdkBytes base32StringSeed;
    private final SdkBytes qrCodePNG;
    private final User user;
    private final Instant enableDate;

    private VirtualMFADevice(BuilderImpl builder) {
        this.serialNumber = builder.serialNumber;
        this.base32StringSeed = builder.base32StringSeed;
        this.qrCodePNG = builder.qrCodePNG;
        this.user = builder.user;
        this.enableDate = builder.enableDate;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public SdkBytes base32StringSeed() {
        return this.base32StringSeed;
    }

    public SdkBytes qrCodePNG() {
        return this.qrCodePNG;
    }

    public User user() {
        return this.user;
    }

    public Instant enableDate() {
        return this.enableDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.base32StringSeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.qrCodePNG());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMFADevice)) {
            return false;
        }
        VirtualMFADevice other = (VirtualMFADevice)obj;
        return Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.base32StringSeed(), other.base32StringSeed()) && Objects.equals(this.qrCodePNG(), other.qrCodePNG()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.enableDate(), other.enableDate());
    }

    public String toString() {
        return ToString.builder((String)"VirtualMFADevice").add("SerialNumber", (Object)this.serialNumber()).add("Base32StringSeed", (Object)(this.base32StringSeed() == null ? null : "*** Sensitive Data Redacted ***")).add("QRCodePNG", (Object)(this.qrCodePNG() == null ? null : "*** Sensitive Data Redacted ***")).add("User", (Object)this.user()).add("EnableDate", (Object)this.enableDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Base32StringSeed": {
                return Optional.ofNullable(clazz.cast(this.base32StringSeed()));
            }
            case "QRCodePNG": {
                return Optional.ofNullable(clazz.cast(this.qrCodePNG()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "EnableDate": {
                return Optional.ofNullable(clazz.cast(this.enableDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualMFADevice, T> g) {
        return obj -> g.apply((VirtualMFADevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serialNumber;
        private SdkBytes base32StringSeed;
        private SdkBytes qrCodePNG;
        private User user;
        private Instant enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMFADevice model) {
            this.serialNumber(model.serialNumber);
            this.base32StringSeed(model.base32StringSeed);
            this.qrCodePNG(model.qrCodePNG);
            this.user(model.user);
            this.enableDate(model.enableDate);
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final ByteBuffer getBase32StringSeed() {
            return this.base32StringSeed == null ? null : this.base32StringSeed.asByteBuffer();
        }

        @Override
        public final Builder base32StringSeed(SdkBytes base32StringSeed) {
            this.base32StringSeed = StandardMemberCopier.copy((SdkBytes)base32StringSeed);
            return this;
        }

        public final void setBase32StringSeed(ByteBuffer base32StringSeed) {
            this.base32StringSeed(base32StringSeed == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)base32StringSeed));
        }

        public final ByteBuffer getQrCodePNG() {
            return this.qrCodePNG == null ? null : this.qrCodePNG.asByteBuffer();
        }

        @Override
        public final Builder qrCodePNG(SdkBytes qrCodePNG) {
            this.qrCodePNG = StandardMemberCopier.copy((SdkBytes)qrCodePNG);
            return this;
        }

        public final void setQrCodePNG(ByteBuffer qrCodePNG) {
            this.qrCodePNG(qrCodePNG == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)qrCodePNG));
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        @Override
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        public VirtualMFADevice build() {
            return new VirtualMFADevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualMFADevice> {
        public Builder serialNumber(String var1);

        public Builder base32StringSeed(SdkBytes var1);

        public Builder qrCodePNG(SdkBytes var1);

        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder enableDate(Instant var1);
    }
}

