/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableMfaDeviceRequest
extends IamRequest
implements ToCopyableBuilder<Builder, EnableMfaDeviceRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnableMfaDeviceRequest.getter(EnableMfaDeviceRequest::userName)).setter(EnableMfaDeviceRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnableMfaDeviceRequest.getter(EnableMfaDeviceRequest::serialNumber)).setter(EnableMfaDeviceRequest.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> AUTHENTICATION_CODE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnableMfaDeviceRequest.getter(EnableMfaDeviceRequest::authenticationCode1)).setter(EnableMfaDeviceRequest.setter(Builder::authenticationCode1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationCode1").build()}).build();
    private static final SdkField<String> AUTHENTICATION_CODE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EnableMfaDeviceRequest.getter(EnableMfaDeviceRequest::authenticationCode2)).setter(EnableMfaDeviceRequest.setter(Builder::authenticationCode2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationCode2").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SERIAL_NUMBER_FIELD, AUTHENTICATION_CODE1_FIELD, AUTHENTICATION_CODE2_FIELD));
    private final String userName;
    private final String serialNumber;
    private final String authenticationCode1;
    private final String authenticationCode2;

    private EnableMfaDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.authenticationCode1 = builder.authenticationCode1;
        this.authenticationCode2 = builder.authenticationCode2;
    }

    public String userName() {
        return this.userName;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String authenticationCode1() {
        return this.authenticationCode1;
    }

    public String authenticationCode2() {
        return this.authenticationCode2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationCode1());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationCode2());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMfaDeviceRequest)) {
            return false;
        }
        EnableMfaDeviceRequest other = (EnableMfaDeviceRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.authenticationCode1(), other.authenticationCode1()) && Objects.equals(this.authenticationCode2(), other.authenticationCode2());
    }

    public String toString() {
        return ToString.builder((String)"EnableMfaDeviceRequest").add("UserName", (Object)this.userName()).add("SerialNumber", (Object)this.serialNumber()).add("AuthenticationCode1", (Object)this.authenticationCode1()).add("AuthenticationCode2", (Object)this.authenticationCode2()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "AuthenticationCode1": {
                return Optional.ofNullable(clazz.cast(this.authenticationCode1()));
            }
            case "AuthenticationCode2": {
                return Optional.ofNullable(clazz.cast(this.authenticationCode2()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableMfaDeviceRequest, T> g) {
        return obj -> g.apply((EnableMfaDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private String authenticationCode1;
        private String authenticationCode2;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMfaDeviceRequest model) {
            super(model);
            this.userName(model.userName);
            this.serialNumber(model.serialNumber);
            this.authenticationCode1(model.authenticationCode1);
            this.authenticationCode2(model.authenticationCode2);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getAuthenticationCode1() {
            return this.authenticationCode1;
        }

        @Override
        public final Builder authenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
            return this;
        }

        public final void setAuthenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
        }

        public final String getAuthenticationCode2() {
            return this.authenticationCode2;
        }

        @Override
        public final Builder authenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
            return this;
        }

        public final void setAuthenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableMfaDeviceRequest build() {
            return new EnableMfaDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableMfaDeviceRequest> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder authenticationCode1(String var1);

        public Builder authenticationCode2(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

