/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;

public class ListGroupsPublisher
implements SdkPublisher<ListGroupsResponse> {
    private final IamAsyncClient client;
    private final ListGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsPublisher(IamAsyncClient client, ListGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsPublisher(IamAsyncClient client, ListGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Group> groups() {
        return this.flatMapIterable(response -> response.groups());
    }

    private class ListGroupsResponseFetcher
    implements AsyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListGroupsResponse> nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsPublisher.this.client.listGroups(ListGroupsPublisher.this.firstRequest);
            }
            return ListGroupsPublisher.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

