/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;

public class SimulatePrincipalPolicyPublisher
implements SdkPublisher<SimulatePrincipalPolicyResponse> {
    private final IamAsyncClient client;
    private final SimulatePrincipalPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SimulatePrincipalPolicyPublisher(IamAsyncClient client, SimulatePrincipalPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SimulatePrincipalPolicyPublisher(IamAsyncClient client, SimulatePrincipalPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SimulatePrincipalPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super SimulatePrincipalPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationResult> evaluationResults() {
        return this.flatMapIterable(response -> response.evaluationResults());
    }

    private class SimulatePrincipalPolicyResponseFetcher
    implements AsyncPageFetcher<SimulatePrincipalPolicyResponse> {
        private SimulatePrincipalPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulatePrincipalPolicyResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<SimulatePrincipalPolicyResponse> nextPage(SimulatePrincipalPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulatePrincipalPolicyPublisher.this.client.simulatePrincipalPolicy(SimulatePrincipalPolicyPublisher.this.firstRequest);
            }
            return SimulatePrincipalPolicyPublisher.this.client.simulatePrincipalPolicy((SimulatePrincipalPolicyRequest)((Object)SimulatePrincipalPolicyPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

