/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;

public class ListUserPoliciesPublisher
implements SdkPublisher<ListUserPoliciesResponse> {
    private final IamAsyncClient client;
    private final ListUserPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserPoliciesPublisher(IamAsyncClient client, ListUserPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserPoliciesPublisher(IamAsyncClient client, ListUserPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> policyNames() {
        return this.flatMapIterable(response -> response.policyNames());
    }

    private class ListUserPoliciesResponseFetcher
    implements AsyncPageFetcher<ListUserPoliciesResponse> {
        private ListUserPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListUserPoliciesResponse> nextPage(ListUserPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoliciesPublisher.this.client.listUserPolicies(ListUserPoliciesPublisher.this.firstRequest);
            }
            return ListUserPoliciesPublisher.this.client.listUserPolicies((ListUserPoliciesRequest)((Object)ListUserPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

